package com.digiwin.athena.domain.core.process;

import lombok.Data;

@Data
public class ActionMapping {

    /**
     * 触发条件表达式 - 编译时加上return
     */
    private String expression;

    /**
     * workflow使用，后置没有NODE_PASS
     * ESP/HTTP/Script/NODE_PASS
     * MODEL_UPDATE会在编译时变成ESP
     */
    private String actionType;

    /**
     * 设计时使用
     * ESP/HTTP/Script/NODE_PASS/MODEL_UPDATE(模型更新)
     */
    private String adpType;

    /**
     * 前后置相关动作
     */
    private ActionConfig actionCfg;

    /**
     * 跳过/终止流程
     * "actionSkip/actionAbort"
     */
    private String exceptionPolicy;
}