package com.digiwin.athena.domain.customBizTask;

import lombok.Data;

import java.util.List;

/**
 * 特定场景业务 - 业务流自定义配置
 */
@Data
public class CustGroupSkipCondition {
	/**
	 * 操作符号 等于（==）， 不等于（!=） , 包含于（in），不包含于(notIn)
	 */
	private String operator;
	/**
	 * 字段
	 */
	private String key;

	/**
	 * 字段名称
	 */
	private String name;
	/**
	 * 变量表达式，用于给SD判断是否跳过任务
	 */
	private String var;
	/**
	 * 字段值
	 */
	private Object value;

	/**
	 * 特定长场景业务 - 是否跳过
	 */
	private Boolean customSkip;

	/**
	 * 数据源action
	 */
	private CustomSkipAction action;
	/**
	 * 字段内容展示 - 用于交付设计器前端
	 */
	private List<CustomSkipFieldContent> contents;
	/**
	 * 判断是否跳过的表达式 - 用于SD
	 */
	private List<CustomSkipExpression> expressions;
}


