package com.digiwin.athena.domain.definition;

import com.digiwin.athena.domain.common.BaseObject;
import lombok.Data;

import java.util.Map;

/**
 performerType:
     user 用户
     duty 职能
     userSuperior 直接主管
     deptDirector 部门主管
     deptUser 部门人员
     personInCharge 当责者
     decision 签核核决（兼容签核人设定）
 performerValue:
    eocUserId/dutyId/deptId/deptId/
 **/
@Data
public class Identity extends BaseObject {

    @Deprecated
    /**
     * 为true时从活动中获取数据
     */
    private Boolean isBusiness;
    /**
     * 执行者类型,人 职能  部门 operation等等
     */
    private String performerType;
    /**
     * 执行者值,用户ID 职能ID 部门ID 等等
     */
    private Object performerValue;
    /**
     * 执行者名称,用户姓名 职能名称 部门名称 等等
     */
    private String performerName;
    /**
     * 执行完活动返回的数据字段
     */
    private String performerVariable;
    /**
     * 公司ID
     */
    private String companyId;
    /**
     * 配置信息
     */
    private Map<String,Object> config;
}
