package com.digiwin.athena.kg.action;


import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.definition.actions.ActionParam;
import com.digiwin.athena.domain.definition.actions.DataEntity;
import com.digiwin.athena.domain.definition.actions.DataField;
import lombok.Data;
import org.neo4j.ogm.annotation.Relationship;

import java.util.List;
import java.util.Map;

/**

 todo    已有数据的国际化修改   actionName_tw desc_tw

 todo json修改 response_object request_parameters

 **/

@Data
public class Action extends TenantObject {

    private String productName;

    private String title;
    private String actionId;
    private String serviceName;
    private String serviceVersion;
    private String actionName;
    private String desc;
    private String url;
    private String method;
    //json
    private String response_object;
    //json
    private String request_parameters;
    private String expression;
    private String target;
    private String type;
    @Relationship(type = "Requires")
    private List<DataField> requires;
    @Relationship(type = "Creates")
    private List<DataField> createsField;
    @Relationship(type = "Requires")
    private List<DataEntity> requiresEntity;
    @Relationship(type = "Creates")
    private List<DataEntity> createsEntity;


    //发起任务时候标准该任务是否紧急 默认值50
    @Deprecated
    private Integer emergency=50;
    private String variableName;
    private String ruleId;
    private Boolean isServiceComposition;
    private String taskId;
    private String processId;
    private String allocateType;
    private String seq;


    private List<ActionParam> actionParams;
    private List<Action> attachActions;

    private Boolean defaultAction;

    private Boolean dispatchBPM;
    private Boolean terminateProcess;
    private Integer order;
    private Map<String,Object> extendParas;


    private String invokeType;

    private String actionName_tw;

    private String nameSpace;



    //发起任务时候标准该任务是否紧急 默认值50
    


    private String sourceIdKey;

    private Boolean idempotency;

    private String querySchema;

    private String microTrans;

    private String sceneNodeType;

    private String spName;

    private String dataFlowCode;

    private Object apiMeta;

    private Object fixSetting;

    //指标设计新增
    //当前正在设计的指标code
    private String parentMetricCode;
    //当前正在被引用的指标的code
    private String quoteMetricCode;

    private String productLine;

    private String bizParamMeta;

    private String actionMode;

    private Object aggregation;


    public String entityBizCode(){
        return actionId;
    }

    private String locale;
    private Boolean asyncComplete;
    private String serviceComposerId;
    private Boolean split;
    private String relativeUrl;
    private String dataEventId;
    private String subject;
    //是否仅启动服务编排bpm流程
    private boolean serviceComposition;
    private Boolean async;

}
