package com.digiwin.athena.domain.core.dtdflow;


import com.digiwin.athena.domain.common.TenantObject;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;

@Getter
@Setter
@Document(collection="process")
public class FlowProcess extends TenantObject {
    /**
     * 流程id
     */
    private String processId;
    /**
     * 流程名称
     */
    private String processName;
    /**
     * 流程类型
     */
    private Integer processType;
    /**
     * 流程版本
     */
    private Integer processVersion;
    /**
     * 设计版本
     */
    private Integer designVersion;
    /**
     * 项目code
     */
    private String projectCode;
    /**
     * 项目配置
     */
    private Map<String,Object> projectConfig;
    /**
     * 流程配置
     */
    private Map<String,Object> processConfig;
    /**
     * 限制配置
     */
    private Map<String,Object> limitConfig;
    /**
     * 表单绑定
     */
    private Map<String,Object> bindForm;
    /**
     * 生命周期配置
     */
    private Map<String,Object> lifecycle;
    /**
     * 自定义变量配置
     */
    private Map<String,Object> customVariable;
    /**
     * 入参变量配置
     */
    private Map<String,Object> requiredVariables;
    /**
     * adp类型
     */
    private String adpType;
    /**
     * dtd流程变量
     */
    private List<Map<String,Object>> dtdVariable;

    /**
     * 当责者
     */
    private Object personInCharge;
}
