package com.digiwin.athena.domain.core.process;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.athena.domain.core.view.PageView;
import com.digiwin.athena.dto.MultiLanguageDTO;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.data.mongodb.core.mapping.Field;

import java.util.List;
import java.util.Map;

/**
 * @author yueyyc
 * @version 1.0
 * @date 2023/12/15 10:15
 */
public class ProcessConfigNode {
    //流程节点的id
    @Field("id")
    private String id;
    //流程节点的类型
    private String type;
    // executor 子节点的类型
    private String subType;
    //流程节点的名称
    private String name;
    private String describe;
    private Map<String, MultiLanguageDTO> lang;
    private String nodeType;
    private String state;    //start/end  区分开始网关和结束合并网关
    //签核设置
    private Map<String, Object> executor;
    private Map<String, Object> strategyConfig;
    private String returnExecutionStrategy;

    // 界面选择
    private Map<String, Object> bindForm;

    //是否开启自定义摘要
    private Boolean enableCustomDigest;

    // 核决权限
    private ProcessDecisionConfig decisionConfig;

    private List<FieldConfigNode> fieldConfig;
    private List<Map<String, Object>> _buttons;
    private Boolean milestone;
    private String taskCode;
    private String taskName;
    private Map<String, Object> serviceConfig;
    //条件节点
    private Integer sort;
    private List<Map<String, Object>> conditionList;
    // UI模式下存贮的信息
    private List<FilterCondition> queryConditions;
    // 条件节点选择的筛选模式  脚本模式与UI模型
    private String conditionMode;
    //脚本模式下存贮的信息
    private String queryConditionScript;
    private List<Map<String, Object>> allFields;
    private ModelSelObj modelSelObj;
    @JSONField(name = "_nodeId")
    private String _nodeId;
    @JSONField(name = "_nodeType")
    private String _nodeType;
    @JSONField(name = "_eventId")
    private String _eventId;
    @JSONField(name = "_eventName")
    private String _eventName;
    @JSONField(name = "_eventBody")
    private String _eventBody;

    // 并行分支的id，给所有并行分支内的节点加了一个id
    private String parallelStartId;

    // 条件分支的id，给所有条件分支内的节点加了一个id
    private String conditionStartId;

    // 前端使用，后端只是存储
    @JSONField(name = "_isValidPassed")
    private Object _isValidPassed;
    // 结束节点选择的界面
    @JSONField(name = "_events")
    private List<ProcessNodeEvent> _events;

    // 事件触发的节点配置，定时触发的节点配置
    private ProcessTriggerConfig triggerConfig;

    private Map<String, String> limitConfig;

    /**
     * 数据节点-新增|更新
     */
    private List<FiledInfo> fieldInfos;

    /**
     * 数据节点-新增类型
     * addSingle单个新增，addMult多个新增
     */
    private String addType;

    /**
     * 数据节点-数据来源-删除|获取
     * business：业务对象,数据节点：node
     */
    private String dataSource;

    /**
     * 数据节点-删除数据|获取数据
     * dataSource 为 node的情况下有值
     */
    private List<String> nodeList;

    /**
     * 数据节点-获取数据
     * 全部：noFilter,按条件查询：condition
     */
    private String dataFilter;

    /**
     * 数据节点-获取数据
     * 无排序:no,降序:desc,升序:asc
     */
    private String orderRule;

    /**
     * 数据节点-获取数据 -排序
     */
    private List<DataViewOrder> orderList;

    /**
     * 人工节点-新增任务卡
     */
    private PageView pageView;

    /**
     * 人工节点-转派 默认勾选
     */
    private Boolean transfer = true;

    /**
     * 人工节点-选择新增任务卡后的task记录-冗余字段
     */
    private Object task;

    /**
     * 人工节点-数据映射-用于页面回调
     */
    private VariablesMapping variablesMapping;

    /**
     * 人工节点-数据映射-编译后用于SD存贮
     */
    private VariablesMappingScript variablesMappingScript;

    /**
     * 默认勾选，勾选后即开启数据分组，禁止取消勾选
     */
    private Boolean openDataGroup;

    /**
     * 在openDataGroup打开时候展示，默认不勾选, checkbox发送空的任务卡
     */
    private Boolean sendBlankCard;

    /**
     * 开启任务卡合并
     */
    private Boolean openTaskMerge;

    /**
     * 开启分批提交
     */
    private Boolean openGroupSubmit;

    /**
     * 数据分组的类型,byKey字段分组/byCondition条件分组
     */
    private String groupType;

    /**
     * byKey时候  key1,key2
     */
    private String groupData;

    /**
     * 运行态使用
     */
    private List<String> groupKeys;

    /**
     * 数据分组的类型,byKey字段分组/byCondition条件分组
     */
    private ProcessGroupDataSource groupDataSource;

    /**
     * 条件分组时过滤类型 UI模式过滤器过滤'filter'
     */
    private String filterType;

    /**
     * 数据分组条件筛选
     */
    private List<List<FilterCondition>> groupingQueryConditions;

    /**
     * 数据分组脚本模式下存贮的信息
     */
    private String groupingQueryConditionScript;

    /**
     * 数据分组-用于前端记录筛选条件
     */
    private List<List<Map<String, Object>>> groupingConditionList;

    /**
     * 数据分组的数据来源-运行态使用
     */
    private String groupDataSourceName;

    /**
     * 数据分组的数据来源的条件数组-运行态使用
     */
    private List<String> groupConditions;


    // 查询多条数据视图模式的 产品
    private String prod;


    // 查询多条数据视图模式的 数字，【businessCode,dataViewCode】
    private String[] dataView;

    /**
     * 预完日字段配置
     */
    private PlanEndTimeDefinition planEndTime;

    /**
     * 里程碑节点隐藏判断
     */
    @JsonProperty("isHideKey")
    private Boolean isHideKey;

    /**
     * 人工节点的前后置操作
     */
    private NodeActionMapping actions;

    /**
     * 子项目的配置添加，等待节点的配置
     */
    private NodeExtendConfig config;

    /**
     * 结束节点输出映射
     */
    private EndOutput endOutput;

    public EndOutput getEndOutput() {
        return endOutput;
    }

    public void setEndOutput(EndOutput endOutput) {
        this.endOutput = endOutput;
    }

    public NodeExtendConfig getConfig() {
        return config;
    }

    public void setConfig(NodeExtendConfig config) {
        this.config = config;
    }

    /**
     * 任务催办开关
     */
    private Boolean urging;

    /**
     * 消息通知-新 - 场景sid
     */
    private String sceneSid;

    /**
     * 消息通知-新 - 场景id
     */
    private String sceneId;

    /**
     * 启用交付设计器开关
     */
    private Boolean allowInteractiveFlag;
    /**
     * 启用交付设计器子开关
     */
    private InteractiveAbleConfig interactiveAbleConfig;

    public String getSceneSid() {
        return sceneSid;
    }

    public void setSceneSid(String sceneSid) {
        this.sceneSid = sceneSid;
    }

    public String getSceneId() {
        return sceneId;
    }

    public void setSceneId(String sceneId) {
        this.sceneId = sceneId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSubType() {
        return subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescribe() {
        return describe;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public Map<String, MultiLanguageDTO> getLang() {
        return lang;
    }

    public void setLang(Map<String, MultiLanguageDTO> lang) {
        this.lang = lang;
    }

    public String getNodeType() {
        return nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Map<String, Object> getExecutor() {
        return executor;
    }

    public void setExecutor(Map<String, Object> executor) {
        this.executor = executor;
    }

    public Map<String, Object> getStrategyConfig() {
        return strategyConfig;
    }

    public void setStrategyConfig(Map<String, Object> strategyConfig) {
        this.strategyConfig = strategyConfig;
    }

    public String getReturnExecutionStrategy() {
        return returnExecutionStrategy;
    }

    public void setReturnExecutionStrategy(String returnExecutionStrategy) {
        this.returnExecutionStrategy = returnExecutionStrategy;
    }

    public Map<String, Object> getBindForm() {
        return bindForm;
    }

    public void setBindForm(Map<String, Object> bindForm) {
        this.bindForm = bindForm;
    }

    public Boolean getEnableCustomDigest() {
        return enableCustomDigest;
    }

    public void setEnableCustomDigest(Boolean enableCustomDigest) {
        this.enableCustomDigest = enableCustomDigest;
    }

    public ProcessDecisionConfig getDecisionConfig() {
        return decisionConfig;
    }

    public void setDecisionConfig(ProcessDecisionConfig decisionConfig) {
        this.decisionConfig = decisionConfig;
    }

    public List<FieldConfigNode> getFieldConfig() {
        return fieldConfig;
    }

    public void setFieldConfig(List<FieldConfigNode> fieldConfig) {
        this.fieldConfig = fieldConfig;
    }

    @JSONField(name = "_buttons")
    public List<Map<String, Object>> get_buttons() {
        return _buttons;
    }

    @JSONField(name = "_buttons")
    public void set_buttons(List<Map<String, Object>> _buttons) {
        this._buttons = _buttons;
    }

    public Boolean getMilestone() {
        return milestone;
    }

    public void setMilestone(Boolean milestone) {
        this.milestone = milestone;
    }

    public String getTaskCode() {
        return taskCode;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public Map<String, Object> getServiceConfig() {
        return serviceConfig;
    }

    public void setServiceConfig(Map<String, Object> serviceConfig) {
        this.serviceConfig = serviceConfig;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public List<Map<String, Object>> getConditionList() {
        return conditionList;
    }

    public void setConditionList(List<Map<String, Object>> conditionList) {
        this.conditionList = conditionList;
    }

    public List<FilterCondition> getQueryConditions() {
        return queryConditions;
    }

    public void setQueryConditions(List<FilterCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public String getConditionMode() {
        return conditionMode;
    }

    public void setConditionMode(String conditionMode) {
        this.conditionMode = conditionMode;
    }

    public String getQueryConditionScript() {
        return queryConditionScript;
    }

    public void setQueryConditionScript(String queryConditionScript) {
        this.queryConditionScript = queryConditionScript;
    }

    public List<Map<String, Object>> getAllFields() {
        return allFields;
    }

    public void setAllFields(List<Map<String, Object>> allFields) {
        this.allFields = allFields;
    }

    public ModelSelObj getModelSelObj() {
        return modelSelObj;
    }

    public void setModelSelObj(ModelSelObj modelSelObj) {
        this.modelSelObj = modelSelObj;
    }

    @JSONField(name = "_nodeId")
    public String get_nodeId() {
        return _nodeId;
    }

    @JSONField(name = "_nodeId")
    public void set_nodeId(String _nodeId) {
        this._nodeId = _nodeId;
    }

    @JSONField(name = "_nodeType")
    public String get_nodeType() {
        return _nodeType;
    }

    @JSONField(name = "_nodeType")
    public void set_nodeType(String _nodeType) {
        this._nodeType = _nodeType;
    }

    @JSONField(name = "_eventId")
    public String get_eventId() {
        return _eventId;
    }

    @JSONField(name = "_eventId")
    public void set_eventId(String _eventId) {
        this._eventId = _eventId;
    }

    @JSONField(name = "_eventName")
    public String get_eventName() {
        return _eventName;
    }

    @JSONField(name = "_eventName")
    public void set_eventName(String _eventName) {
        this._eventName = _eventName;
    }

    @JSONField(name = "_eventBody")
    public String get_eventBody() {
        return _eventBody;
    }

    @JSONField(name = "_eventBody")
    public void set_eventBody(String _eventBody) {
        this._eventBody = _eventBody;
    }

    public String getParallelStartId() {
        return parallelStartId;
    }

    public void setParallelStartId(String parallelStartId) {
        this.parallelStartId = parallelStartId;
    }

    public String getConditionStartId() {
        return conditionStartId;
    }

    public void setConditionStartId(String conditionStartId) {
        this.conditionStartId = conditionStartId;
    }

    @JSONField(name = "_isValidPassed")
    public Object get_isValidPassed() {
        return _isValidPassed;
    }

    @JSONField(name = "_isValidPassed")
    public void set_isValidPassed(Object _isValidPassed) {
        this._isValidPassed = _isValidPassed;
    }

    @JSONField(name = "_events")
    public List<ProcessNodeEvent> get_events() {
        return _events;
    }

    @JSONField(name = "_events")
    public void set_events(List<ProcessNodeEvent> _events) {
        this._events = _events;
    }

    public ProcessTriggerConfig getTriggerConfig() {
        return triggerConfig;
    }

    public void setTriggerConfig(ProcessTriggerConfig triggerConfig) {
        this.triggerConfig = triggerConfig;
    }

    public Map<String, String> getLimitConfig() {
        return limitConfig;
    }

    public void setLimitConfig(Map<String, String> limitConfig) {
        this.limitConfig = limitConfig;
    }

    public List<FiledInfo> getFieldInfos() {
        return fieldInfos;
    }

    public void setFieldInfos(List<FiledInfo> fieldInfos) {
        this.fieldInfos = fieldInfos;
    }

    public String getAddType() {
        return addType;
    }

    public void setAddType(String addType) {
        this.addType = addType;
    }

    public String getDataSource() {
        return dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public List<String> getNodeList() {
        return nodeList;
    }

    public void setNodeList(List<String> nodeList) {
        this.nodeList = nodeList;
    }

    public String getDataFilter() {
        return dataFilter;
    }

    public void setDataFilter(String dataFilter) {
        this.dataFilter = dataFilter;
    }

    public String getOrderRule() {
        return orderRule;
    }

    public void setOrderRule(String orderRule) {
        this.orderRule = orderRule;
    }

    public List<DataViewOrder> getOrderList() {
        return orderList;
    }

    public void setOrderList(List<DataViewOrder> orderList) {
        this.orderList = orderList;
    }

    public PageView getPageView() {
        return pageView;
    }

    public void setPageView(PageView pageView) {
        this.pageView = pageView;
    }

    public Boolean getTransfer() {
        return transfer;
    }

    public void setTransfer(Boolean transfer) {
        this.transfer = transfer;
    }

    public Object getTask() {
        return task;
    }

    public void setTask(Object task) {
        this.task = task;
    }

    public VariablesMapping getVariablesMapping() {
        return variablesMapping;
    }

    public void setVariablesMapping(VariablesMapping variablesMapping) {
        this.variablesMapping = variablesMapping;
    }

    public VariablesMappingScript getVariablesMappingScript() {
        return variablesMappingScript;
    }

    public void setVariablesMappingScript(VariablesMappingScript variablesMappingScript) {
        this.variablesMappingScript = variablesMappingScript;
    }

    public Boolean getOpenDataGroup() {
        return openDataGroup;
    }

    public void setOpenDataGroup(Boolean openDataGroup) {
        this.openDataGroup = openDataGroup;
    }

    public Boolean getSendBlankCard() {
        return sendBlankCard;
    }

    public void setSendBlankCard(Boolean sendBlankCard) {
        this.sendBlankCard = sendBlankCard;
    }

    public Boolean getOpenTaskMerge() {
        return openTaskMerge;
    }

    public void setOpenTaskMerge(Boolean openTaskMerge) {
        this.openTaskMerge = openTaskMerge;
    }

    public Boolean getOpenGroupSubmit() {
        return openGroupSubmit;
    }

    public void setOpenGroupSubmit(Boolean openGroupSubmit) {
        this.openGroupSubmit = openGroupSubmit;
    }

    public String getGroupType() {
        return groupType;
    }

    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    public String getGroupData() {
        return groupData;
    }

    public void setGroupData(String groupData) {
        this.groupData = groupData;
    }

    public List<String> getGroupKeys() {
        return groupKeys;
    }

    public void setGroupKeys(List<String> groupKeys) {
        this.groupKeys = groupKeys;
    }

    public ProcessGroupDataSource getGroupDataSource() {
        return groupDataSource;
    }

    public void setGroupDataSource(ProcessGroupDataSource groupDataSource) {
        this.groupDataSource = groupDataSource;
    }

    public String getFilterType() {
        return filterType;
    }

    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public List<List<FilterCondition>> getGroupingQueryConditions() {
        return groupingQueryConditions;
    }

    public void setGroupingQueryConditions(List<List<FilterCondition>> groupingQueryConditions) {
        this.groupingQueryConditions = groupingQueryConditions;
    }

    public String getGroupingQueryConditionScript() {
        return groupingQueryConditionScript;
    }

    public void setGroupingQueryConditionScript(String groupingQueryConditionScript) {
        this.groupingQueryConditionScript = groupingQueryConditionScript;
    }

    public List<List<Map<String, Object>>> getGroupingConditionList() {
        return groupingConditionList;
    }

    public void setGroupingConditionList(List<List<Map<String, Object>>> groupingConditionList) {
        this.groupingConditionList = groupingConditionList;
    }

    public String getGroupDataSourceName() {
        return groupDataSourceName;
    }

    public void setGroupDataSourceName(String groupDataSourceName) {
        this.groupDataSourceName = groupDataSourceName;
    }

    public List<String> getGroupConditions() {
        return groupConditions;
    }

    public void setGroupConditions(List<String> groupConditions) {
        this.groupConditions = groupConditions;
    }

    public String getProd() {
        return prod;
    }

    public void setProd(String prod) {
        this.prod = prod;
    }

    public String[] getDataView() {
        return dataView;
    }

    public void setDataView(String[] dataView) {
        this.dataView = dataView;
    }

    public PlanEndTimeDefinition getPlanEndTime() {
        return planEndTime;
    }

    public void setPlanEndTime(PlanEndTimeDefinition planEndTime) {
        this.planEndTime = planEndTime;
    }

    public NodeActionMapping getActions() {
        return actions;
    }

    public void setActions(NodeActionMapping actions) {
        this.actions = actions;
    }

    public Boolean getUrging() {
        return urging;
    }

    public void setUrging(Boolean urging) {
        this.urging = urging;
    }

    public Boolean getIsHideKey() { return isHideKey; }
    public void setIsHideKey(Boolean isHideKey) { this.isHideKey = isHideKey; }

    public Boolean getAllowInteractiveFlag() {
        return allowInteractiveFlag;
    }

    public void setAllowInteractiveFlag(Boolean allowInteractiveFlag) {
        this.allowInteractiveFlag = allowInteractiveFlag;
    }

    public InteractiveAbleConfig getInteractiveAbleConfig() {
        return interactiveAbleConfig;
    }

    public void setInteractiveAbleConfig(InteractiveAbleConfig interactiveAbleConfig) {
        this.interactiveAbleConfig = interactiveAbleConfig;
    }
}
