package com.digiwin.athena.kg.action;

import com.digiwin.athena.kg.domain.DomainEntity;
import lombok.Data;
import org.neo4j.ogm.annotation.Relationship;

import java.util.List;

/**
    一个抽象的具体实现,一般都会指向具体实现的主体,如果实体是多个代表是多个主体共同决定该实现
 **/
@Data
public class AbstractionEntity extends DomainEntity implements Abstraction {

    private String key;
    /*@see Abstraction*/
    private Integer dimension;

    private String name;
    private String description;

    @Relationship(type="relatedTo")
    private List<DomainEntity> subject;
    @Relationship(type="absEntity")
    private List<AbstractionEntity> entity;

    private List<Variable> params;

    public String entityBizCode(){
        return key;
    }
}
