package com.digiwin.athena.kg.monitorRule;



import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.kg.action.Action;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import org.neo4j.ogm.annotation.Relationship;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

/**
 * @Param
 * @return
 * @Author wangxiao
 * @Date 2021/8/11 18:11
 * @Description //侦测规则
 **/
@Data
@Document(collection = "monitorRule")
public class MonitorRule extends TenantObject {

    // datapulling  task serviceComposer
    private String actionType;
    //actionType=task 为projectCode   actionType=serviceComposer为serviceComposerId 这两种场景下没有Aciton
    private String actionCommonId;
//    @Id
//    private String objectId;


    //需要触发的actionId
    private String triggerAction;

    private String entity;
    //多个字段之间用逗号分割
    private String returnFields;
    //SCAN,API,SCHEDULE
    private String category;
    //侦测时间、频率
    private StandardPollingRule standardPollingRule;
    ///type有MODIFIED 修改，CREATED 新增，APPROVED 审核， CUSTOM 自定义
    private String type;
    @JsonProperty(value = "isContinue")
    private Boolean isContinue = false;
    //租户别的条件,应该对应到kgsys中的monitorRuleProductConfig字段，这里没用
    private DynamicCondition dynamicCondition;
    //对于到多少产品
    private List<MonitorRuleProduct> product;
    //动态条件
    private List<DynamicParam> dynamicParams;
    //静态条件
    private List<DynamicParam> staticParams;
    //monitorAction
    private String monitorActionId;
    //是否缓存去重
    @JsonProperty(value = "isPollingIds")
    private Boolean isPollingIds = true;
    // 动态条件字段
    private String dynamicConditionFields;
    // 是否是从运行态数据库中迁移到设计态数据库
    private Boolean isMigrate;

    // 回溯时间 侦测开始时间”=“回溯时间 标记,设计时不需要
//    private String backtrackDate;
//    private Boolean backtrackDateEqualsStartTime;

    // 是否创建侦测时立即执行一次
    private Boolean executeOnStartup;
    // 是否自动创建侦测
    private Boolean autoRun;
    // 是否允许在交付设计器设置，是就会在applicationRealtion中生成一条关联关系，否则不生成,默认true，发版不需要
    private Boolean isDesignerSet = true;


    //用于多个MonitorRule传参，很尴尬
    private String dynamicParamsDto;

    private List<String> inclusionTenant;


    @Relationship(type="Triggers")
    private List<Action> actions;
    private String pollingInterval;


    //是否允许(立即)执行
    private Integer executable;
    //周期开关 分号分隔 M;W;D;H;F M每x月 W每x周 D每x天 H每x小时 F每x分钟
    private String periodEnable;

    // 回溯时间
    private String backtrackDate;
    //“侦测开始时间”=“回溯时间 标记
    private Boolean backtrackDateEqualsStartTime;
    // 是否数据比对
    private boolean dataCheck;
    //给sd的防抖冷却时间
    private Integer chillInterval;


    private String productName;

    private String nameSpace;

    // 敏捷报表定义 场景
    private String scene;
    // 敏捷报表定义 执行引擎需要定义入参
    private String actionParamDefine;

    /*****************************MQTT start类型的侦测参数************************/
    //业务主题
    private String mqttTopic;
    //主题来源
    private String mqttSource;

}
