package com.digiwin.athena.kg.monitorRule;


import lombok.Data;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2023-03-15 16:17
 **/
@Data
public class StandardPollingRuleDesign {
    static Map<String,String> week = new HashMap<>();
    static {
        week.put("0","SU");
        week.put("1","MO");
        week.put("2","TU");
        week.put("3","WE");
        week.put("4","TH");
        week.put("5","FR");
        week.put("6","SA");
    }
    //2023-03-15
    private String startTime;
    //month week day hour minute fixInterval
    private String timeType;
    //月 1;08:00,周 1;08:00,日 08:00,小时 1,分 15
    private String timeValue;
    //day month year
    private String interval;
    //:自定义，2关联机制参数
    private Integer startTimeType;
    //code值
    private String startVariableCode;


    public StandardPollingRule toStandardPollingRule(){
        StandardPollingRule standardPollingRule = new StandardPollingRule();
        String startTime = this.startTime;
        switch (timeType){
            case "month":
                standardPollingRule.setMonthly(1);
                String[] timevalues1 = timeValue.split(";");
                standardPollingRule.setBymonthday(Integer.parseInt(timevalues1[0]));
                startTime = startTime+" "+timevalues1[1]+":00";
                break;
            case "week":
                standardPollingRule.setWeekly(1);
                String[] timevalues2 = timeValue.split(";");
                standardPollingRule.setByday(week.get(timevalues2[0]));
                startTime = startTime+" "+timevalues2[1]+":00";
                break;
            case "day":
                standardPollingRule.setRepeat_type(3);
                //每天 OK? 测也不测的功能也敢往上发?
                standardPollingRule.setFrequency(1);
                startTime = startTime+" "+timeValue+":00";
                break;
            case "hour":
                standardPollingRule.setRepeat_type(2);
                //史荣俊写的
                standardPollingRule.setFrequency((int)Double.parseDouble(timeValue));
                startTime = startTime+" 00:00:00";
                break;
            case "minute":
                standardPollingRule.setRepeat_type(1);
                //史荣俊写的
                standardPollingRule.setFrequency((int)Double.parseDouble(timeValue));
                startTime = startTime+" 00:00:00";
                break;
            case "fixInterval":
                if (!isLegalInterval(interval)) {
                    //缺省为day
                    interval = "day";
                }
                switch (interval) {
                    case "day":
                        String repeatFrequency = "1";
                        String hourTime;
                        if (isLegalTimeValue(timeValue)) {
                            hourTime = timeValue.split(";")[1];
                            repeatFrequency = timeValue.split(";")[0];
                        } else {
                            hourTime = timeValue;
                        }
                        standardPollingRule.setRepeat_type(3);
                        standardPollingRule.setFrequency(Integer.parseInt(repeatFrequency));
                        startTime = startTime+" "+hourTime+":00";
                        break;
                }
        }
        if(!StringUtils.isEmpty(startTimeType)){
            standardPollingRule.setStartTimeType(startTimeType);
        }

        if(!StringUtils.isEmpty(startVariableCode)){
            standardPollingRule.setStartVariableCode(startVariableCode);
        }

        standardPollingRule.setStart_time(startTime);
        return standardPollingRule;
    }

    private boolean isLegalTimeValue(String timeValue) {
        //先放行,默认合法
        return true;
    }

    private boolean isLegalInterval(String interval) {
        if (StringUtils.isEmpty(interval)) {
            return false;
        } else {
            //目前只有day合法,后期新增其他则增加类型
            return interval.equals("day");
        }
    }

}
