package com.digiwin.athena.mechanism.common;

import lombok.Getter;
import lombok.Setter;

import java.util.Arrays;
import java.util.Optional;

/**
 * @Description 机制相关枚举值
 * @Author liugl
 * @Date 2024/6/27 13:12
 **/
public interface MechanismEnum {
	/**
	 * 前端控件类型
	 */
	enum ComponentType {
		SELECTOR("selector", "下拉选择"),
		OPEN_WINDOW("openWindow", "开窗"),
		NUMERIC("numeric", "数值"),
		OPTION("option", "下拉选择"),
		CHECK_VALID("checkValid", "校验提示"),
		ASSIGNMENT("assignment", "赋值"),
		;

		@Getter
		@Setter
		private String code;

		@Getter
		@Setter
		private String name;

		/**
		 * 有参构造
		 * @param code
		 * @param name
		 */
		ComponentType(String code, String name) {
			this.code = code;
			this.name = name;
		}
	}

	/**
	 * 应用类型
	 */
	enum ConditionType {
		HALF_CUSTOM("half_custom", "半定制"),
		STANDARD("standard", "标准化"),
		PRIMARY("primary", "基本条件"),
		HIGH_GRADE("highGrade", "高级条件"),
		CONDITION("condition", "条件"),// 条件类，包括基本条件和高级条件，主要区分于api
		API("api", "API"),
		LIMIT_CONDITION("limitCondition", "限制");

		@Getter
		@Setter
		private String code;

		@Getter
		@Setter
		private String name;

		/**
		 * 有参构造
		 * @param code
		 * @param name
		 */
		ConditionType(String code, String name) {
			this.code = code;
			this.name = name;
		}
	}

	/**
	 * 前端字段数值类型
	 */
	enum FieldValueType {
		STRING("string", "字符串") ,
		NUMERIC("numeric", "数值类型"),
		BOOLEAN("boolean", "布尔类型"),
		DATETIME("datetime", "日期时间类型"),
		DATE("date", "日期类型") ;

		@Getter
		@Setter
		private String code;

		@Getter
		@Setter
		private String name;
		/**
		 * 有参构造
		 * @param code
		 * @param name
		 */
		FieldValueType(String code, String name) {
			this.code = code;
			this.name = name;
		}
	}

	/**
	 * 右侧判断条件类型
	 */
	enum RightCondType {
		ENUM_TYPE("enum", "枚举值") ,
		CUSTOM_VALUE("customValue", "自定义值"),
		MECHANISM_VARIABLE("mechanismVariable", "机制参数"),
		CUSTOM_FUNCTION("customFunction", "自定义函数"),
		TASK("task", "任务字段") ;

		@Getter
		@Setter
		private String code;

		@Getter
		@Setter
		private String name;
		/**
		 * 有参构造
		 * @param code
		 * @param name
		 */
		RightCondType(String code, String name) {
			this.code = code;
			this.name = name;
		}
	}

	/**
	 * 操作类型
	 */
	enum OperateType {
		EQ("eq", "等于") ,
		GT("gt", "大于"),
		LT("lt", "小于"),
		GTE("gte", "大于等于"),
		LTE("lte", "小于等于"),
		BETWEEN("between", "之间") ;

		@Getter
		@Setter
		private String code;

		@Getter
		@Setter
		private String name;
		/**
		 * 有参构造
		 * @param code
		 * @param name
		 */
		OperateType(String code, String name) {
			this.code = code;
			this.name = name;
		}
	}

	/**
	 * 自定义方法类型
	 */
	enum FunctionType {
		SUM("sum", "numeric","求和") ,
		MAX("max", "numeric","求最大值"),
		MIN("min", "numeric","求最小值"),
		AVG("avg", "numeric","求平均值"),
		COUNT("count", "numeric","计数"),
		EXIST("exist", "boolean","求是否存在") ,
		COUNT_DIS("countd", "numeric","去重计数") ;

		@Getter
		@Setter
		private String code;

		@Getter
		@Setter
		private String outputType;

		@Getter
		@Setter
		private String name;

		/**
		 * 有参构造
		 *
		 * @param code
		 * @param name
		 */
		FunctionType(String code, String outputType, String name) {
			this.code = code;
			this.outputType = outputType;
			this.name = name;
		}
	}

	/**
	 * 限制条件类型
	 */
	enum LimitConditionType {
		BUSINESS("businessCondition", "业务条件"),
		PERSONNEL("personnelCondition", "人员条件");

		@Getter
		@Setter
		private String code;

		@Getter
		@Setter
		private String name;

		/**
		 * 有参构造
		 *
		 * @param code
		 * @param name
		 */
		LimitConditionType(String code, String name) {
			this.code = code;
			this.name = name;
		}
	}

	/**
	 * 限制条件类型
	 */
	enum PersonnelConditionType {
		PROFICIENCY("proficiency", "熟练度"),
		DUTY("duty", "职能"),
		STAFF("staff", "人员");

		@Getter
		@Setter
		private String code;

		@Getter
		@Setter
		private String name;

		/**
		 * 有参构造
		 *
		 * @param code
		 * @param name
		 */
		PersonnelConditionType(String code, String name) {
			this.code = code;
			this.name = name;
		}
	}

	/**
	 * 限制动作类型
	 */
	enum LimitActionType {
		REMINDER("reminder", "提醒"),
		LIMIT_ACTION("limitAction", "限制行动"),
		AUTO_PROCESS("autoProcess", "自动处理");

		@Getter
		@Setter
		private String code;

		@Getter
		@Setter
		private String name;

		/**
		 * 有参构造
		 *
		 * @param code
		 * @param name
		 */
		LimitActionType(String code, String name) {
			this.code = code;
			this.name = name;
		}
	}

	/**
	 * 限制动作类型
	 */
	enum LimitTaskExecuteType {
		REQUIRED("required", "必填", "checkValid"),
		HIDDEN("hidden", "隐藏", ""),
		DISABLED("disabled", "只读", ""),
		SCOPE_LIMIT("scopeLimit", "可编辑范围", "checkValid");

		@Getter
		@Setter
		private String code;

		@Getter
		@Setter
		private String name;

		@Getter
		@Setter
		private String componentType;

		/**
		 * 有参构造
		 * @param code
		 * @param name
		 * @param componentType
		 */
		LimitTaskExecuteType(String code, String name, String componentType) {
			this.code = code;
			this.name = name;
			this.componentType = componentType;
		}

		public static String getComponentType(String code) {
			LimitTaskExecuteType[] values = LimitTaskExecuteType.values();
			Optional<LimitTaskExecuteType> firstOptional = Arrays.stream(values).filter(v -> v.getCode().equalsIgnoreCase(code)).findFirst();
			if (firstOptional.isPresent()) {
				LimitTaskExecuteType limitTaskExecuteType = firstOptional.get();
				return limitTaskExecuteType.getComponentType();
			}
			return "";
		}
	}
}
