package com.digiwin.athena.kmservice.action.metadata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.kg.action.*;
import com.digiwin.athena.kmservice.service.KmDBCommonService;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.MergeUtil;
import com.digiwin.athena.kmservice.utils.MetadataTranslator;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;


@Service
public class ActionMetadataManager {

    @Autowired
    private KmDBCommonService kmDBCommonService;
    @Autowired(required = false)
    private ActionRepository actionRepository;

    public EspActionMetadataDTO getActionMetadata(String actionId) throws Exception {
        ActionMetadata actionMetadataByActionId = this.kmDBCommonService.getActionMetadataByActionId(actionId);
        if (actionMetadataByActionId == null) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.actionNotFound2") + actionId);
        }

        EspActionMetadataDTO metadataDTO = new EspActionMetadataDTO();
        metadataDTO.setActionId(actionId);
        metadataDTO.setServiceName(actionMetadataByActionId.getServiceName());

        //去除转义字符
        ActionRequestMetadataDTO requestMetadataDTO = new ActionRequestMetadataDTO();
        requestMetadataDTO.setParameters(JSON.parseArray(JSONObject.toJSONString(actionMetadataByActionId.getRequestParameters()), ApiDataFieldMetadataDTO.class));

        ActionResponseMetadataDTO responseMetadataDTO = new ActionResponseMetadataDTO();
        responseMetadataDTO.setData(JSON.parseObject(JSONObject.toJSONString(actionMetadataByActionId.getResponseObject()), ApiDataFieldMetadataDTO.class));

        metadataDTO.setRequest(requestMetadataDTO);
        metadataDTO.setResponse(responseMetadataDTO);

        return metadataDTO;
    }

    public EspActionMetadataDTO getActionMetadata(String actionId, String tenantId, String tenantVersion) throws Exception {
        List<ActionLabel> actionAndLabels = MergeUtil.excludeWithSameCode(actionRepository.getActionAndLabels(actionId, tenantId, tenantVersion),
                actionLabel -> actionLabel.getAction().entityBizCode(),
                actionLabel -> actionLabel.getAction().getSourceLevel());
        if (CollectionUtils.isEmpty(actionAndLabels)) {
            throw new DWBusinessException("P.KG.500.0001",I18nUtils.getValue("knowledgegraph.actionNotFound",actionId,tenantId));
        }
        Action action = actionAndLabels.get(0).getAction();
        EspActionMetadataDTO metadataDTO = new EspActionMetadataDTO();
        metadataDTO.setActionId(actionId);
        metadataDTO.setServiceName(action.getServiceName());
        metadataDTO.setIdempotency(action.getIdempotency());
        metadataDTO.setName(action.getName());
        metadataDTO.setActionName(action.getActionName());
        metadataDTO.setActionName_tw(action.getActionName_tw());
        metadataDTO.setInvokeType(action.getInvokeType());
        //去除转义字符
        ActionRequestMetadataDTO requestMetadataDTO = new ActionRequestMetadataDTO();
        requestMetadataDTO.setParameters(JSON.parseArray(action.getRequest_parameters(), ApiDataFieldMetadataDTO.class));

        ActionResponseMetadataDTO responseMetadataDTO = new ActionResponseMetadataDTO();
        responseMetadataDTO.setData(JSON.parseObject(action.getResponse_object(), ApiDataFieldMetadataDTO.class));

        metadataDTO.setRequest(requestMetadataDTO);
        metadataDTO.setResponse(responseMetadataDTO);

        metadataDTO.setSceneNodeType(action.getSceneNodeType());

        return metadataDTO;
    }


    public List<GetActionLocaleResponseDTO> getActionMetadatas(List<String> actionIds, String tenantId, String tenantVersion) throws Exception {
        List<ActionLabel> actionAndLabels = MergeUtil.excludeWithSameCode(actionRepository.getActionAndLabels(actionIds, tenantId, tenantVersion),
                actionLabel -> actionLabel.getAction().entityBizCode(),
                actionLabel -> actionLabel.getAction().getSourceLevel());
        if (CollectionUtils.isEmpty(actionAndLabels)) {
            throw new DWBusinessException("P.KG.500.0001",I18nUtils.getValue("knowledgegraph.actionNotFound",actionIds.toString(),tenantId));
        }
        return doPostActionMetadata(actionAndLabels);
    }

    public List<GetActionLocaleResponseDTO> getActionMetadatasByDataFlowCode(List<String> actionIds, String tenantId, String tenantVersion) throws Exception {
        List<ActionLabel> actionAndLabels = MergeUtil.excludeWithSameCode(actionRepository.getActionAndLabelsByDataFlowCode(actionIds, tenantId, tenantVersion),
                actionLabel -> actionLabel.getAction().entityBizCode(),
                actionLabel -> actionLabel.getAction().getSourceLevel());
        if (CollectionUtils.isEmpty(actionAndLabels)) {
            throw new DWBusinessException("P.KG.500.0001",I18nUtils.getValue("knowledgegraph.actionNotFound",actionIds.toString(),tenantId));
        }
        return doPostActionMetadata(actionAndLabels);
    }

    private List<GetActionLocaleResponseDTO> doPostActionMetadata(List<ActionLabel> actionAndLabels) {
        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();
        List<GetActionLocaleResponseDTO> metadataDTOs = new ArrayList<>();
        for (ActionLabel actionLabel :actionAndLabels) {
            Action action = actionLabel.getAction();
            EspActionMetadataDTO metadataDTO = new EspActionMetadataDTO();
            metadataDTO.setActionId(action.getActionId());
            metadataDTO.setServiceName(action.getServiceName());
            metadataDTO.setIdempotency(action.getIdempotency());
            metadataDTO.setName(action.getName());
            metadataDTO.setActionName(action.getActionName());
            metadataDTO.setActionName_tw(action.getActionName_tw());
            metadataDTO.setDataFlowCode(action.getDataFlowCode());
            //去除转义字符
            ActionRequestMetadataDTO requestMetadataDTO = new ActionRequestMetadataDTO();
            requestMetadataDTO.setParameters(JSON.parseArray(action.getRequest_parameters(), ApiDataFieldMetadataDTO.class));

            ActionResponseMetadataDTO responseMetadataDTO = new ActionResponseMetadataDTO();
            responseMetadataDTO.setData(JSON.parseObject(action.getResponse_object(), ApiDataFieldMetadataDTO.class));

            metadataDTO.setRequest(requestMetadataDTO);
            metadataDTO.setResponse(responseMetadataDTO);

            metadataDTO.setSceneNodeType(action.getSceneNodeType());

            GetActionLocaleResponseDTO localeResponseDTO = JSON.parseObject(JSON.toJSONString(metadataDTO),
                    GetActionLocaleResponseDTO.class);
            // 不需要查字段精度，不传产品
            MetadataTranslator.translateField(localeResponseDTO, metadataDTO, localeStr, null);
            metadataDTOs.add(localeResponseDTO);
        }
        return metadataDTOs;
    }
}
