package com.digiwin.athena.kmservice.cache;

import com.digiwin.athena.kmservice.utils.ServiceUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Aspect
@Component("cacheAspect2")
@Slf4j
@Order(100)
public class CacheAspect {

    @Autowired
    private RedisTemplate redisTemplate;

    @Around("@annotation(com.digiwin.athena.kmservice.cache.Cache)")
    public Object processCache(ProceedingJoinPoint jp) throws Throwable {
        final Signature sig = jp.getSignature();
        final MethodSignature msig = (MethodSignature) sig;
        final Method method = msig.getMethod();
        final Cache annotation = method.getAnnotation(Cache.class);
        String key = annotation.key();
        if(StringUtils.isEmpty(key)){
            return jp.proceed();
        }
        Map<String,Object> param = new HashMap<>();
        Object[] args = jp.getArgs();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; i++) {
            Parameter parameter = parameters[i];
            String parameterName = parameter.getName();
            Object parameterValue = args[i];
            param.put(parameterName,parameterValue);
        }
        Object keyObj =  ServiceUtils.evalExpressionWithContext(key,param);
        Object result = redisTemplate.opsForValue().get(keyObj);
        if(null!=result){
            if(log.isInfoEnabled()){
                log.info("get data from cache with key({})", keyObj);
            }
            return result;
        }
        result = jp.proceed();
        if(null!=result){
            redisTemplate.opsForValue().set(keyObj,result, annotation.ttlSecs(),TimeUnit.SECONDS);
        }
        return result;
    }


}
