package com.digiwin.athena.kmservice.neo4j;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;

import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.util.Pair;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class Neo4jCrudService {

    @Autowired(required = false)
    @Qualifier("neo4jDriverDomain1")
    private Driver driver1;

    @Autowired(required = false)
    @Qualifier("neo4jDriverDomain2")
    private Driver driver2;


    @Autowired
    SessionFactory sessionFactory;



    public void executeCypher(String cql, Map<String,Object> params){
        Neo4jMultipleUtil.executeCql(cql, params, driver1, driver2);
    }

    public void executeCyphers(List<String> cqls, Map<String,Object> params){
        List<List<String>> splits = ListUtil.split(cqls,1000);
        int count = 0;
        int total = cqls.size();
        for (List<String> split : splits) {
            count = count+ split.size();
            List<Cql> collect = split.stream().map(cql -> new Cql().setCql(cql).setParams(params)).collect(Collectors.toList());
            Neo4jMultipleUtil.executeCqlTrans(collect,driver1,driver2);
        }
    }


    public List<Map<String, Object>> query(String statement, Map<String, Object> params) {
        List<Map<String, Object>> list = new ArrayList<>();
        Session session = sessionFactory.openSession();
        Result result = session.query(statement,params);
        result.forEach(stringObjectMap -> {
            Map<String, Object> item = new HashMap<>();
            stringObjectMap.forEach((k,v)->{
                if(v instanceof NodeModel){
                    NodeModel node = (NodeModel)v;
                    node.getPropertyList().forEach(p->{
                        item.put(p.getKey(),p.getValue());
                    });
                }else{
                    item.put(k,v);
                }
            });
            list.add(item);
        });
        return list;
    }

    public List<Map<String,Object>> queryCol(String col,Map<String,Object> params){
        List<Map<String,Object>> list = new ArrayList<>();
       Session session = sessionFactory.openSession();
       StringBuilder sb = new StringBuilder();
       sb.append("match(n:").append(col).append(")").append(" where 1=1 ");
        params.forEach((k,v)->{
            sb.append(" and n.").append(k);
            if(v instanceof Collection || v.getClass().isArray()){
                sb.append(" in ");
            } else {
               sb.append(" = ");
            }
            sb.append(" $").append(k).append("");
        });

       sb.append(" return n;");
       String cql = sb.toString();
       Result result = session.query(cql,params);
       result.forEach(map->{
           Object n = map.get("n");
           if(n instanceof NodeModel){
               NodeModel node = (NodeModel)n;
               Map map2 = new HashMap();
               node.getPropertyList().forEach(p->{
                   map2.put(p.getKey(),p.getValue());
               });
               list.add(map2);
           }else {
               list.add(JSON.parseObject(JSON.toJSONString(n)));
           }
       });
       return list;
    }


    public void delete(String col,Map<String,Object> params){
        StringBuilder sb = new StringBuilder();
        sb.append("match(n:").append(col).append(")").append(" where 1=1 ");
        params.forEach((k,v)->{
            sb.append(" and n.").append(k);
            if(v instanceof Collection || v.getClass().isArray()){
                sb.append(" in ");
            } else {
                sb.append(" = ");
            }
            sb.append(" $").append(k).append("");
        });

        sb.append(" detach delete n");
        String cql = sb.toString();
        executeCypher(cql,params);
    }


    public void createRelation(String fromTable,Map<String,Object> fromParams,String toTable,Map<String,Object> toParams,String relation){
        StringBuilder sb = new StringBuilder();
        sb.append("match(a:").append(fromTable).append("),(b:").append(toTable).append(") where 1=1 ");
        sb.append(paramAnd(fromParams,"a")).append(paramAnd(toParams,"b"));
        sb.append(" merge (a)-[:").append(relation).append("]->(b) ");
        String cyhper = sb.toString();
        //todo 需要两个param不存在冲突的key
        Map<String,Object> params = new HashMap<>();
        params.putAll(fromParams);
        params.putAll(toParams);
        executeCypher(cyhper, params);
    }

    public void createRelation(String fromTable,Map<String,Object> fromParams,List<String> toTables,Map<String,Object> toParams,String relation){
        StringBuilder sb = new StringBuilder();
        sb.append("match(a:").append(fromTable).append("),(b) where 1=1 ");
        sb.append(paramAnd(fromParams,"a")).append(paramAnd(toParams,"b"));
        sb.append(" and any(label in labels(b) where label in $toTables) create (a)-[:").append(relation).append("]->(b) ");
        String cyhper = sb.toString();

        executeCypher(cyhper, MapUtil.of("toTables",toTables));
    }

    public void updateVersion(String app, String version, String updateVersion){
        String cypher = "match(n{athena_namespace:$app,version:$version}) set n.version=$updateVersion";
        Map<String,Object> params = new HashMap<>();
        params.put("app",app);
        params.put("version",version);
        params.put("updateVersion",updateVersion);
        executeCypher(cypher,params);
    }

    public void updateTenantVersion(List<String> tenantIds, String updateVersion){
        String cypher = "match(n:TenantEntity) where n.tenantId in $tenantIds set n.version=$updateVersion";
        Map<String,Object> params = new HashMap<>();
        params.put("tenantIds",tenantIds);
        params.put("updateVersion",updateVersion);
        executeCypher(cypher,params);
    }

    public void executeCyphers(List<Cql> cqlList){
        Neo4jMultipleUtil.executeCqlTrans(cqlList, driver1, driver2);
    }

    private static String paramMap(Map<String,Object> param){
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        param.forEach((k,v)->{
            sb.append(k).append(":");
            if(v instanceof String){
                sb.append("'").append(v).append("'");
            }else if( v instanceof Collection){

            }
            else{
                sb.append(v);
            }
            sb.append(",");
        });
        if(param.size()>0){
            sb.deleteCharAt(sb.length()-1);
        }
        sb.append("}");
        return sb.toString();
    }

    public static String paramAnd(Map<String,Object> params,String alias){
        StringBuilder sb = new StringBuilder();
        params.forEach((k,v)->{
            sb.append(" and ").append(alias).append(".").append(k);
            if(v instanceof Collection || v.getClass().isArray()){
                sb.append(" in ");
            } else {
                sb.append(" = ");
            }
            sb.append(" $").append(k).append("");
        });
        return sb.toString();
    }




    public void cleanNeo4jData(String label,Map<String,Object> params) {
        List<Cql> cqlList = new ArrayList<>();
        StringBuilder sb = new StringBuilder();
        sb.append("MATCH (node:").append(label).append(") where 1=1");
        params.forEach((k,v)->{
            String op = "=";
            if(v instanceof Collection){
                op = " in ";
            }
            sb.append(" and node.").append(k).append(op).append("$").append(k);
        });
        sb.append(" detach delete node");
        String cql =sb.toString(); //"MATCH (node)  where node.version =$version and node.sourceId=$sourceId detach delete node";
        cqlList.add(new Cql().setCql(cql).setParams(params));
        Neo4jMultipleUtil.executeCqlTrans(cqlList, driver1, driver2);
    }

    private List<Map<String, Object>> queryWithPagination(String label, Map<String, Object> params, int skip, int limit) {
        List<Map<String, Object>> list = new ArrayList<>();
        Session session = sessionFactory.openSession();
        StringBuilder sb = new StringBuilder();
        sb.append("MATCH (n:").append(label).append(") WHERE 1=1 ");
        params.forEach((k, v) -> {
            sb.append(" AND n.").append(k);
            if (v instanceof Collection || v.getClass().isArray()) {
                sb.append(" IN ");
            } else {
                sb.append(" = ");
            }
            sb.append(" $").append(k);
        });
        sb.append(" RETURN n SKIP ").append(skip).append(" LIMIT ").append(limit);
        String cql = sb.toString();
        Result result = session.query(cql, params);
        result.forEach(map -> {
            Object n = map.get("n");
            if (n instanceof NodeModel) {
                NodeModel node = (NodeModel) n;
                Map<String, Object> map2 = new HashMap<>();
                node.getPropertyList().forEach(p -> {
                    map2.put(p.getKey(), p.getValue());
                });
                list.add(map2);
            } else {
                list.add(JSON.parseObject(JSON.toJSONString(n)));
            }
        });
        return list;
    }

}
