package com.digiwin.athena.kmservice.utils;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.common.Constants;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.domain.core.view.PageUIElement;
import com.digiwin.athena.kmservice.support.MergePolicy;
import com.digiwin.athena.kmservice.support.MergePolicyBuilder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.lang.reflect.Field;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Slf4j
@Component
public class MergeUtil {


    public static   <T extends TenantObject>  List<T> excludeSameCode(List<T> ts0,  Class<T> c, Map<String, Object> eocInfo) throws DWBusinessException {
        List<T> ts = new ArrayList<>();
        if(CollectionUtils.isEmpty(ts0)){return ts0;}
        Map<String,List<T>> codeListMap = new HashMap<>();
        ts0.forEach(t->{
            codeListMap.computeIfAbsent(t.entityBizCode(),k->new ArrayList<>()).add(t);
        });
        boolean tenantOperationUnitV2 = IAMUtils.isTenantOperationUnitV2FromContext();
        codeListMap.forEach((k,v)->{
            T t =  tenantOperationUnitV2 ? mergeEntityV2(v, c, eocInfo) : mergeEntity(v, c, eocInfo);
            if(null!=t){
                ts.add(t);
            }
        });

        return ts;
    }

    /**
     * 删除系统级数据
     *
     * @param ts  相同业务主键的实体对象列表
     * @param <T> 泛型
     * @return 返回删除重复的实体对象列表
     */
    public static <T extends TenantObject> T chooseOneWithSameCode(List<T> ts) {
        if (CollectionUtils.isEmpty(ts)) {
            return null;
        }
        for (T t : ts) {
            if ("SYSTEM".equals(t.getTenantId()) || StringUtils.isEmpty(t.getTenantId())) {
                t.setSourceLevel(1000);
            }
            if (null == t.getSourceLevel()) {
                t.setSourceLevel(200);
            }
        }
        ts.sort(Comparator.comparing(T::getSourceLevel));
        return ts.get(0);
    }

    public static  <T extends TenantObject>  T mergeEntity(List<T> sameCodeList,  Class<T> c, Map<String, Object> eocInfo){
        T result=null;
        T system=null;
        T tenantPlugin=null;
        T tenant=null;
        T company=null;
        T site=null;
        for(T t:sameCodeList){
            if(Constants.SYSTEM.equals(t.getTenantId())){
                t.setSourceLevel(1000);
            }
            if(null!=t.getSourceLevel()){
                if(null==system){
                    system=t;
                }else{
                    if(t.getSourceLevel()<system.getSourceLevel()){
                        system = t;
                    }
                }
                continue;
            }
            if(CollectionUtils.isEmpty(t.getEocInfo())){
                if(null!=t.getPluginId()){
                    tenantPlugin = t;
                    if(null==tenantPlugin.getPriority()){tenantPlugin.setPriority(0);}
                    tenantPlugin.setPriority(tenantPlugin.getPriority()+1);
                }else{
                    tenant =t;
                    if(null==tenant.getPriority()){tenant.setPriority(0);}
                    tenant.setPriority(tenant.getPriority()+1);
                }

                continue;
            }
            if(!CollectionUtils.isEmpty(eocInfo)){
                String eoc_company_id = MapUtils.getString(eocInfo, Constants.eoc_company_id);
                String eoc_site_id = MapUtils.getString(eocInfo, Constants.eoc_site_id);
                String eoc_company_id2 = MapUtils.getString(t.getEocInfo(), Constants.eoc_company_id);
                String eoc_site_id2 = MapUtils.getString(t.getEocInfo(), Constants.eoc_site_id);;
                if(StringUtils.isNotEmpty(eoc_company_id) && eoc_company_id.equals(eoc_company_id2)){
                    if(StringUtils.isEmpty(eoc_site_id2)){
                        company =t;
                    }else if(eoc_site_id2.equals(eoc_site_id)){
                        site = t;
                    }
                }
            }
        }

        MergePolicy mergePolicy= MergePolicyBuilder.getPolicy(c.getName());
        result =mergeEntity0(mergePolicy,system,tenantPlugin,tenant,company,site);
        return result;
    }

    /**
     * 数据合并
     * @param sameCodeList 待合并的数据，包含系统级和组户级
     * @param c 实体类
     * @param eocInfo 运营单元信息
     * @return 合并后的实体对象
     * @param <T> 泛型
     */
    public static <T extends TenantObject> T mergeEntityV2(List<T> sameCodeList, Class<T> c, Map<String, Object> eocInfo) {
        T result = null;
        T system = null;
        T tenant=null;
        T tenantPlugin = null;
        Iterator<T> iterator = sameCodeList.iterator();
        List<T> eocList = sameCodeList.stream().filter(t -> JSONPath.eval(t.getEocInfo(), "$.operation_unit_v2.eoc_mapping_id") != null).collect(Collectors.toList());
        while (iterator.hasNext()) {
            T t = iterator.next();
            // 找系统级数据
            if (Constants.SYSTEM.equals(t.getTenantId())) {
                t.setSourceLevel(1000);
            }
            if (null != t.getSourceLevel()) {
                if (null == system) {
                    system = t;
                } else {
                    if (t.getSourceLevel() < system.getSourceLevel()) {
                        system = t;
                    }
                }
                continue;
            }
            // 找到到插件级数据
            if (CollectionUtils.isEmpty(t.getEocInfo())) {
                if (null != t.getPluginId()) {
                    tenantPlugin = t;
                    if (null == tenantPlugin.getPriority()) {
                        tenantPlugin.setPriority(0);
                    }
                    tenantPlugin.setPriority(tenantPlugin.getPriority() + 1);
                }else {
                    tenant = t;
                    if (null == tenant.getPriority()) {
                        tenant.setPriority(0);
                    }
                    tenant.setPriority(tenant.getPriority() + 1);
                }
            }
        }
        String operationPath = MapUtils.getString(eocInfo, "operationPath");
        // operationPath为a.b.c这种，剩下的数据需要根据路径去排好序
        if (StringUtils.isNotEmpty(operationPath)) {
            String[] order = operationPath.split(":");
            Map<String, Integer> orderMap = new HashMap<>();
            for (int i = 0; i < order.length; i++) {
                orderMap.put(order[i], i); // 构建ID到排序索引的映射
            }
            eocList.sort(Comparator.comparingInt(item -> {
                Object eval = JSONPath.eval(item.getEocInfo(), "$.operation_unit_v2.eoc_mapping_id");
                return orderMap.get(String.valueOf(eval));
            }));
        }
        if (tenant != null) {
            eocList.add(0, tenant);
        }
        if (tenantPlugin != null) {
            eocList.add(0, tenantPlugin);
        }
        if (system != null) {
            eocList.add(0, system);
        }
        MergePolicy mergePolicy = MergePolicyBuilder.getPolicy(c.getName());
        result = mergeEntity0(mergePolicy, eocList);
        return result;
    }

    private static  <T extends TenantObject> T mergeEntity0(MergePolicy mergePolicy, T... sources){
        T t =null;
        for(T source:sources){
            if(null==t){
                t = source;
            }else{
                mergeObject(source,t,mergePolicy);
            }
        }
        return t;
    }

    private static  <T extends TenantObject> T mergeEntity0(MergePolicy mergePolicy, List<T> sources){
        T t =null;
        for(T source:sources){
            if(null==t){
                t = source;
            }else{
                mergeObject(source,t,mergePolicy);
            }
        }
        return t;
    }

        public static void mergeObjectSimple(Object source, Object to,Set excludeFields)   {
        if(null==source || null==to ){return;}
        if(!isMapOrObject(source)){return;}
        Set<String> excludes = excludeFields;
        if(null==excludes){excludes = new HashSet<>();}
        if(source instanceof Map){
            Map sourcemap = (Map) source;
            Map tomap = (Map) to;
            for(Object k:sourcemap.entrySet()){
                Object v = sourcemap.get(k);
                if(null==v || excludes.contains(k)){continue;}
                if("lang".equals(k) && k instanceof Map && null!= tomap.get(k) ){
                    tomap.putAll((Map) v);
                }else{
                    tomap.put(k,v);
                }
            }
        }else{
            //复合类型
            List<Field> fieldList = ServiceUtils.getFields(source.getClass());
            for(Field f : fieldList){
                try{
                    f.setAccessible(true);
                    Object value = f.get(source);
                    if(null==value || excludes.contains(f.getName())){
                        continue;
                    }
                    Object value2 = f.get(to);
                    if(value2==null){
                        f.set(to,value);
                        continue;
                    }
                    if(value instanceof Map){
                        Map mv = (Map) value;
                        Map mv2 = (Map) value2;
                        if(!mv.isEmpty()){
                            if(source instanceof Activity && "config".equals(f.getName())){
                                Map approve= (Map) mv.get("approve");
                                Map approve2= (Map) mv2.get("approve");
                                mv2.putAll(mv);
                                if(null!=approve && null!=approve2){
                                    approve.putAll(approve2);
                                }
                                continue;
                            }
                            mv2.putAll(mv);
                            f.set(to,mv2);
                        }
                    }else {
                        f.set(to,value);
                    }

                }catch(Exception e){
                    log.error(e.toString());
                }
            }
        }
    }

    public static void mergeObject(Object source, Object to, MergePolicy policy)   {
        if(null==source || null==to ){return;}
        if(!isMapOrObject(source)){return;}
        if(policy.getParsed().contains(source)){return;}
        policy.getParsed().add(source);
        String parent = policy.getPath();
        if(source instanceof Map){
            Map sourcemap = (Map) source;
            Map tomap = to instanceof Map ? (Map) to : BeanUtil.beanToMap(to);
            sourcemap.forEach((k,v)->{
                String path = parent+"."+k;
                if(null!=v && !policy.getExcludes().contains(k)){
                    Object v2 = tomap.get(k);
                    if(isMapOrObject(v) && policy.pathMatch(path) && v2!=null){
                        policy.setPath(path);
                        mergeObject(v,v2,policy);
                    }else {
                        tomap.put(k,v);
                    }
                }
            });
        }else{
            //复合类型
            List<Field> fieldList = ServiceUtils.getFields(source.getClass());
            for(Field f : fieldList){
                try{
                    f.setAccessible(true);
                    String name = f.getName();
                    if(policy.getExcludes().contains(name)){continue;}
                    Object value = f.get(source);
                    if(null==value){
                        continue;
                    }
                    Object value2 = f.get(to);
                    if(value2==null){
                        f.set(to,value);
                        continue;
                    }
                    String path = parent+"."+f.getName();
                    if(isMapOrObject(value) && policy.pathMatch(path)){
                        policy.setPath(path);
                        mergeObject(value,value2,policy);
                    }else{
                        if(value instanceof Map){
                            Map mv = (Map) value;
                            if(!mv.isEmpty()){
                                Map mv2 = (Map) value2;
                                mv2.putAll(mv);
                                f.set(to,mv2);
                            }
                        }else if(value instanceof Collection){
                            Collection cv = (Collection) value;
                            if(cv.size()>0){
                                f.set(to,value);
                            }
                        } else {
                            f.set(to,value);
                        }
                    }
                }catch(Exception e){
                    log.error(e.toString());
                }
            }
        }
    }
    public static boolean isMapOrObject(Object v){
        if(v==null){return false;}
        if(v instanceof Collection || v.getClass().isArray() || ServiceUtils.isPrimitive(v.getClass())){return false;}
        return true;
    }



    public static void mergeObject(Object source,Object to)   {
        List<Field> fieldList = ServiceUtils.getFields(source.getClass());
        for(Field f : fieldList){
            try{
                f.setAccessible(true);
                Object value = f.get(source);
                if(null!=value){
                    if(value instanceof Map){
                        Map mv = (Map) value;
                        if(!mv.isEmpty()){
                            Object value2 = f.get(to);
                            Map mv2 = (Map) value2;
                            if(mv2!=null){
                                mv2.putAll(mv);
                                f.set(to,mv2);
                            }else{
                                f.set(to,value);
                            }
                        }
                    }else if(value instanceof Collection){
                        Collection cv = (Collection) value;
                        if(cv.size()>0){
                            f.set(to,value);
                        }
                    }
                    else {
                        f.set(to,value);
                    }

                }
            }catch(Exception e){
                log.error(e.toString());
            }
        }
    }

    /**
     * 将对象转换成map集合
     * @param init 返回对象,map集合
     * @param obj 初始对象
     * @param excludeFields 转换时需要排除的字段
     * @return
     */
    public static Map<String,Object> mergeObjectToMap(Map<String,Object> init,Object obj,List<String> excludeFields)   {

        if(obj==null){return init;}
        if(null==excludeFields){excludeFields = new ArrayList<>();}
        if(obj instanceof Map){
            Map mapObj = (Map) obj;
            excludeFields.forEach(f->{
                mapObj.remove(f);
            });
            init.putAll(mapObj);
        }else{
            List<Field> fieldList = ServiceUtils.getFields(obj.getClass());
            for(Field f : fieldList){
                if(excludeFields.contains(f.getName())){continue;}
                try{
                    f.setAccessible(true);
                    Object value1 = f.get(obj);
                    if(null!=value1){
                        init.put(f.getName(),value1);
                    }
                }catch(Exception e){
                    log.error(e.toString());
                }
            }
        }

        return init;
    }



    public static <T> T mergeObject(T source, T target, Class<T> clazz, String needField, Boolean forceReplace) {
        Field[] declaredFields = clazz.getDeclaredFields();
        Arrays.stream(declaredFields).filter(v -> v.getName().matches(needField)).forEach(v -> {
            try {
                // 私有属性设置为可访问
                v.setAccessible(true);
                Object strSource = v.get(source);
                Object strTarget = v.get(target);
                // 目标数据字段不存在的则直接跳过不处理
                if (!ObjectUtil.isEmpty(strTarget)) {
                    if (forceReplace) {
                        strSource = strTarget;
                    } else {
                        if (!ObjectUtil.isEmpty(strSource)) {
                            // 源数据字段也存在且不包含目标数据，在后面追加，包含则不处理
                            if (!String.valueOf(strSource).contains(String.valueOf(target))) {
                                strSource = strSource + "\n" + strTarget;
                            }
                        } else {
                            // 源数据不存在直接赋值
                            strSource = strTarget;
                        }
                    }
                }
                v.set(source, strSource);
            } catch (IllegalAccessException e) {
                log.error("合并对象失败", e);
                log.error("入参：source【{}】，target【{}】，clazz【{}】，needField【{}】", source, target, clazz, needField);
            }
        });
        return source;
    }

    /**
     * 批量去除重复数据
     *
     * @param ts              待去除重复数据集合
     * @param uniqueKeyFunc   唯一键函数
     * @param sourceLevelFunc 获取数据sourceLevel的函数
     * @return 去除重复数据集合
     * @throws DWBusinessException 业务异常
     */
    public static <T> List<T> excludeWithSameCode(List<T> ts, Function<T, String> uniqueKeyFunc, Function<T, Integer> sourceLevelFunc) throws DWBusinessException {
        return new ArrayList<>(ts.stream().collect(Collectors.toMap(uniqueKeyFunc, t -> t, (t1, t2) -> Optional.ofNullable(sourceLevelFunc.apply(t1)).orElse(1000) <= Optional.ofNullable(sourceLevelFunc.apply(t2)).orElse(1000) ? t1 : t2, LinkedHashMap::new)).values());
    }
}
