/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.configuration;

import com.alibaba.csp.sentinel.annotation.aspectj.SentinelResourceAspect;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.digiwin.athena.kmservice.configuration.SentinelRuleProp;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class ServiceConfiguration
implements InitializingBean {
    @Autowired
    SentinelRuleProp sentinelRuleProp;

    @Bean
    public ObjectMapper myObjectMapper() {
        ObjectMapper mapper = Jackson2ObjectMapperBuilder.json().simpleDateFormat("yyyy-MM-dd HH:mm:ss").serializationInclusion(JsonInclude.Include.NON_NULL).build();
        return mapper;
    }

    @Bean
    public Executor taskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadGroupName("taskExecutors");
        executor.setThreadNamePrefix("taskExecutors");
        executor.setCorePoolSize(Runtime.getRuntime().availableProcessors() * 2);
        executor.setMaxPoolSize(300);
        executor.setQueueCapacity(0);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }

    @Bean
    public SentinelResourceAspect sentinelResourceAspect() {
        return new SentinelResourceAspect();
    }

    public void initSentinelRules() {
        ArrayList rules = new ArrayList();
        this.sentinelRuleProp.getSources().forEach((k, v) -> {
            FlowRule rule = new FlowRule();
            rule.setResource(k);
            rule.setGrade(1);
            rule.setCount((double)v.intValue());
            rules.add(rule);
        });
        FlowRuleManager.loadRules(rules);
    }

    public void afterPropertiesSet() throws Exception {
        this.initSentinelRules();
    }
}

