/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.utils;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.common.HierarchicalEntity;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.Activity;
import com.digiwin.athena.kmservice.support.MergePolicy;
import com.digiwin.athena.kmservice.support.MergePolicyBuilder;
import com.digiwin.athena.kmservice.utils.IAMUtils;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MergeUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MergeUtil.class);

    public static <T extends TenantObject> List<T> excludeSameCode(List<T> ts0, Class<T> c, Map<String, Object> eocInfo) throws DWBusinessException {
        ArrayList ts = new ArrayList();
        if (CollectionUtils.isEmpty(ts0)) {
            return ts0;
        }
        HashMap<String, List> codeListMap = new HashMap<String, List>();
        ts0.forEach(t -> codeListMap.computeIfAbsent(t.entityBizCode(), k -> new ArrayList()).add(t));
        boolean tenantOperationUnitV2 = IAMUtils.isTenantOperationUnitV2FromContext();
        codeListMap.forEach((k, v) -> {
            Object t;
            Object t2 = t = tenantOperationUnitV2 ? MergeUtil.mergeEntityV2(v, c, eocInfo) : MergeUtil.mergeEntity(v, c, eocInfo);
            if (null != t) {
                ts.add(t);
            }
        });
        return ts;
    }

    public static <T extends TenantObject> T chooseOneWithSameCode(List<T> ts) {
        if (CollectionUtils.isEmpty(ts)) {
            return null;
        }
        for (TenantObject t : ts) {
            if ("SYSTEM".equals(t.getTenantId()) || StringUtils.isEmpty((CharSequence)t.getTenantId())) {
                t.setSourceLevel(Integer.valueOf(1000));
            }
            if (null != t.getSourceLevel()) continue;
            t.setSourceLevel(Integer.valueOf(200));
        }
        ts.sort(Comparator.comparing(HierarchicalEntity::getSourceLevel));
        return (T)((TenantObject)ts.get(0));
    }

    public static <T extends TenantObject> T mergeEntity(List<T> sameCodeList, Class<T> c, Map<String, Object> eocInfo) {
        TenantObject result = null;
        TenantObject system = null;
        TenantObject tenantPlugin = null;
        TenantObject tenant = null;
        TenantObject company = null;
        TenantObject site = null;
        for (TenantObject t : sameCodeList) {
            if ("SYSTEM".equals(t.getTenantId())) {
                t.setSourceLevel(Integer.valueOf(1000));
            }
            if (null != t.getSourceLevel()) {
                if (null == system) {
                    system = t;
                    continue;
                }
                if (t.getSourceLevel() >= system.getSourceLevel()) continue;
                system = t;
                continue;
            }
            if (CollectionUtils.isEmpty((Map)t.getEocInfo())) {
                if (null != t.getPluginId()) {
                    tenantPlugin = t;
                    if (null == tenantPlugin.getPriority()) {
                        tenantPlugin.setPriority(Integer.valueOf(0));
                    }
                    tenantPlugin.setPriority(Integer.valueOf(tenantPlugin.getPriority() + 1));
                    continue;
                }
                tenant = t;
                if (null == tenant.getPriority()) {
                    tenant.setPriority(Integer.valueOf(0));
                }
                tenant.setPriority(Integer.valueOf(tenant.getPriority() + 1));
                continue;
            }
            if (CollectionUtils.isEmpty(eocInfo)) continue;
            String eoc_company_id = MapUtils.getString(eocInfo, (Object)"eoc_company_id");
            String eoc_site_id = MapUtils.getString(eocInfo, (Object)"eoc_site_id");
            String eoc_company_id2 = MapUtils.getString((Map)t.getEocInfo(), (Object)"eoc_company_id");
            String eoc_site_id2 = MapUtils.getString((Map)t.getEocInfo(), (Object)"eoc_site_id");
            if (!StringUtils.isNotEmpty((CharSequence)eoc_company_id) || !eoc_company_id.equals(eoc_company_id2)) continue;
            if (StringUtils.isEmpty((CharSequence)eoc_site_id2)) {
                company = t;
                continue;
            }
            if (!eoc_site_id2.equals(eoc_site_id)) continue;
            site = t;
        }
        MergePolicy mergePolicy = MergePolicyBuilder.getPolicy(c.getName());
        result = MergeUtil.mergeEntity0((MergePolicy)mergePolicy, (TenantObject[])new TenantObject[]{system, tenantPlugin, tenant, company, site});
        return (T)result;
    }

    public static <T extends TenantObject> T mergeEntityV2(List<T> sameCodeList, Class<T> c, Map<String, Object> eocInfo) {
        T result = null;
        TenantObject system = null;
        TenantObject tenant = null;
        TenantObject tenantPlugin = null;
        Iterator<T> iterator = sameCodeList.iterator();
        List eocList = sameCodeList.stream().filter(t -> JSONPath.eval((Object)t.getEocInfo(), (String)"$.operation_unit_v2.eoc_mapping_id") != null).collect(Collectors.toList());
        while (iterator.hasNext()) {
            TenantObject t2 = (TenantObject)iterator.next();
            if ("SYSTEM".equals(t2.getTenantId())) {
                t2.setSourceLevel(Integer.valueOf(1000));
            }
            if (null != t2.getSourceLevel()) {
                if (null == system) {
                    system = t2;
                    continue;
                }
                if (t2.getSourceLevel() >= system.getSourceLevel()) continue;
                system = t2;
                continue;
            }
            if (!CollectionUtils.isEmpty((Map)t2.getEocInfo())) continue;
            if (null != t2.getPluginId()) {
                tenantPlugin = t2;
                if (null == tenantPlugin.getPriority()) {
                    tenantPlugin.setPriority(Integer.valueOf(0));
                }
                tenantPlugin.setPriority(Integer.valueOf(tenantPlugin.getPriority() + 1));
                continue;
            }
            tenant = t2;
            if (null == tenant.getPriority()) {
                tenant.setPriority(Integer.valueOf(0));
            }
            tenant.setPriority(Integer.valueOf(tenant.getPriority() + 1));
        }
        String operationPath = MapUtils.getString(eocInfo, (Object)"operationPath");
        if (StringUtils.isNotEmpty((CharSequence)operationPath)) {
            String[] order = operationPath.split(":");
            HashMap<String, Integer> orderMap = new HashMap<String, Integer>();
            for (int i = 0; i < order.length; ++i) {
                orderMap.put(order[i], i);
            }
            eocList.sort(Comparator.comparingInt(item -> {
                Object eval = JSONPath.eval((Object)item.getEocInfo(), (String)"$.operation_unit_v2.eoc_mapping_id");
                return (Integer)orderMap.get(String.valueOf(eval));
            }));
        }
        if (tenant != null) {
            eocList.add(0, tenant);
        }
        if (tenantPlugin != null) {
            eocList.add(0, tenantPlugin);
        }
        if (system != null) {
            eocList.add(0, system);
        }
        MergePolicy mergePolicy = MergePolicyBuilder.getPolicy(c.getName());
        result = MergeUtil.mergeEntity0(mergePolicy, eocList);
        return result;
    }

    private static <T extends TenantObject> T mergeEntity0(MergePolicy mergePolicy, T ... sources) {
        T t = null;
        for (T source : sources) {
            if (null == t) {
                t = source;
                continue;
            }
            MergeUtil.mergeObject(source, t, mergePolicy);
        }
        return t;
    }

    private static <T extends TenantObject> T mergeEntity0(MergePolicy mergePolicy, List<T> sources) {
        TenantObject t = null;
        for (TenantObject source : sources) {
            if (null == t) {
                t = source;
                continue;
            }
            MergeUtil.mergeObject(source, t, mergePolicy);
        }
        return (T)t;
    }

    public static void mergeObjectSimple(Object source, Object to, Set excludeFields) {
        if (null == source || null == to) {
            return;
        }
        if (!MergeUtil.isMapOrObject(source)) {
            return;
        }
        HashSet excludes = excludeFields;
        if (null == excludes) {
            excludes = new HashSet();
        }
        if (source instanceof Map) {
            Map sourcemap = (Map)source;
            Map tomap = (Map)to;
            for (Map.Entry k : sourcemap.entrySet()) {
                Object v = sourcemap.get(k);
                if (null == v || excludes.contains(k)) continue;
                if ("lang".equals(k) && k instanceof Map && null != tomap.get(k)) {
                    tomap.putAll((Map)v);
                    continue;
                }
                tomap.put(k, v);
            }
        } else {
            List<Field> fieldList = ServiceUtils.getFields(source.getClass());
            for (Field f : fieldList) {
                try {
                    f.setAccessible(true);
                    Object value = f.get(source);
                    if (null == value || excludes.contains(f.getName())) continue;
                    Object value2 = f.get(to);
                    if (value2 == null) {
                        f.set(to, value);
                        continue;
                    }
                    if (value instanceof Map) {
                        Map mv = (Map)value;
                        Map mv2 = (Map)value2;
                        if (mv.isEmpty()) continue;
                        if (source instanceof Activity && "config".equals(f.getName())) {
                            Map approve = (Map)mv.get("approve");
                            Map approve2 = (Map)mv2.get("approve");
                            mv2.putAll(mv);
                            if (null == approve || null == approve2) continue;
                            approve.putAll(approve2);
                            continue;
                        }
                        mv2.putAll(mv);
                        f.set(to, mv2);
                        continue;
                    }
                    f.set(to, value);
                }
                catch (Exception e) {
                    log.error(e.toString());
                }
            }
        }
    }

    public static void mergeObject(Object source, Object to, MergePolicy policy) {
        if (null == source || null == to) {
            return;
        }
        if (!MergeUtil.isMapOrObject(source)) {
            return;
        }
        if (policy.getParsed().contains(source)) {
            return;
        }
        policy.getParsed().add(source);
        String parent = policy.getPath();
        if (source instanceof Map) {
            Map sourcemap = (Map)source;
            Map tomap = to instanceof Map ? (Map)to : BeanUtil.beanToMap((Object)to, (String[])new String[0]);
            sourcemap.forEach((k, v) -> {
                String path = parent + "." + k;
                if (null != v && !policy.getExcludes().contains(k)) {
                    Object v2 = tomap.get(k);
                    if (MergeUtil.isMapOrObject(v) && policy.pathMatch(path) && v2 != null) {
                        policy.setPath(path);
                        MergeUtil.mergeObject(v, v2, policy);
                    } else {
                        tomap.put(k, v);
                    }
                }
            });
        } else {
            List<Field> fieldList = ServiceUtils.getFields(source.getClass());
            for (Field f : fieldList) {
                try {
                    Object value;
                    f.setAccessible(true);
                    String name = f.getName();
                    if (policy.getExcludes().contains(name) || null == (value = f.get(source))) continue;
                    Object value2 = f.get(to);
                    if (value2 == null) {
                        f.set(to, value);
                        continue;
                    }
                    String path = parent + "." + f.getName();
                    if (MergeUtil.isMapOrObject(value) && policy.pathMatch(path)) {
                        policy.setPath(path);
                        MergeUtil.mergeObject(value, value2, policy);
                        continue;
                    }
                    if (value instanceof Map) {
                        Map mv = (Map)value;
                        if (mv.isEmpty()) continue;
                        Map mv2 = (Map)value2;
                        mv2.putAll(mv);
                        f.set(to, mv2);
                        continue;
                    }
                    if (value instanceof Collection) {
                        Collection cv = (Collection)value;
                        if (cv.size() <= 0) continue;
                        f.set(to, value);
                        continue;
                    }
                    f.set(to, value);
                }
                catch (Exception e) {
                    log.error(e.toString());
                }
            }
        }
    }

    public static boolean isMapOrObject(Object v) {
        if (v == null) {
            return false;
        }
        return !(v instanceof Collection) && !v.getClass().isArray() && !ServiceUtils.isPrimitive(v.getClass());
    }

    public static void mergeObject(Object source, Object to) {
        List<Field> fieldList = ServiceUtils.getFields(source.getClass());
        for (Field f : fieldList) {
            try {
                f.setAccessible(true);
                Object value = f.get(source);
                if (null == value) continue;
                if (value instanceof Map) {
                    Map mv = (Map)value;
                    if (mv.isEmpty()) continue;
                    Object value2 = f.get(to);
                    Map mv2 = (Map)value2;
                    if (mv2 != null) {
                        mv2.putAll(mv);
                        f.set(to, mv2);
                        continue;
                    }
                    f.set(to, value);
                    continue;
                }
                if (value instanceof Collection) {
                    Collection cv = (Collection)value;
                    if (cv.size() <= 0) continue;
                    f.set(to, value);
                    continue;
                }
                f.set(to, value);
            }
            catch (Exception e) {
                log.error(e.toString());
            }
        }
    }

    public static Map<String, Object> mergeObjectToMap(Map<String, Object> init, Object obj, List<String> excludeFields) {
        if (obj == null) {
            return init;
        }
        if (null == excludeFields) {
            excludeFields = new ArrayList<String>();
        }
        if (obj instanceof Map) {
            Map mapObj = (Map)obj;
            excludeFields.forEach(f -> mapObj.remove(f));
            init.putAll(mapObj);
        } else {
            List<Field> fieldList = ServiceUtils.getFields(obj.getClass());
            for (Field f2 : fieldList) {
                if (excludeFields.contains(f2.getName())) continue;
                try {
                    f2.setAccessible(true);
                    Object value1 = f2.get(obj);
                    if (null == value1) continue;
                    init.put(f2.getName(), value1);
                }
                catch (Exception e) {
                    log.error(e.toString());
                }
            }
        }
        return init;
    }

    public static <T> T mergeObject(T source, T target, Class<T> clazz, String needField, Boolean forceReplace) {
        Field[] declaredFields = clazz.getDeclaredFields();
        Arrays.stream(declaredFields).filter(v -> v.getName().matches(needField)).forEach(v -> {
            try {
                v.setAccessible(true);
                Object strSource = v.get(source);
                Object strTarget = v.get(target);
                if (!ObjectUtil.isEmpty((Object)strTarget)) {
                    if (forceReplace.booleanValue()) {
                        strSource = strTarget;
                    } else if (!ObjectUtil.isEmpty((Object)strSource)) {
                        if (!String.valueOf(strSource).contains(String.valueOf(target))) {
                            strSource = strSource + "\n" + strTarget;
                        }
                    } else {
                        strSource = strTarget;
                    }
                }
                v.set(source, strSource);
            }
            catch (IllegalAccessException e) {
                log.error("\u5408\u5e76\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
                log.error("\u5165\u53c2\uff1asource\u3010{}\u3011\uff0ctarget\u3010{}\u3011\uff0cclazz\u3010{}\u3011\uff0cneedField\u3010{}\u3011", new Object[]{source, target, clazz, needField});
            }
        });
        return source;
    }

    public static <T> List<T> excludeWithSameCode(List<T> ts, Function<T, String> uniqueKeyFunc, Function<T, Integer> sourceLevelFunc) throws DWBusinessException {
        return new ArrayList(ts.stream().collect(Collectors.toMap(uniqueKeyFunc, t -> t, (t1, t2) -> Optional.ofNullable(sourceLevelFunc.apply(t1)).orElse(1000) <= Optional.ofNullable(sourceLevelFunc.apply(t2)).orElse(1000) ? t1 : t2, LinkedHashMap::new)).values());
    }
}

