package com.digiwin.athena.kmservice.action.metadata;

import com.digiwin.athena.kmservice.common.Neo4jConstants;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.EocActionExecutionDTO;
import org.springframework.stereotype.Component;

import java.util.Map;
@Component
public class EocActionHandlerImpl implements ActionHandler<Map<String, Object>> {
    @Override
    public ActionDefinitionDTO processMetadata(Map<String, Object> actionMatched) throws Exception {
        ActionDefinitionDTO eocDefinitionDTO = new EocActionMetadataGenerator().Generate(actionMatched);
        return eocDefinitionDTO;
    }

    @Override
    public ActionExecutionDTO processExecution(Map<String, Object> actionMatched) throws Exception {
        EocActionExecutionDTO executionDTO = new EocActionExecutionDTO();
        executionDTO.setAllocateType(actionMatched.get(Neo4jConstants.EOC_ALLOCATE_TYPE).toString());
        executionDTO.setActionId(actionMatched.get(Neo4jConstants.PROPERTY_ACTION_ID).toString());
        executionDTO.setForEach(true);
        executionDTO.setType(ActionTypeEnum.EOC);
        return executionDTO;
    }

    @Override
    public String getActionLabel() {
        return Neo4jConstants.LABEL_EOC_ACTION;
    }
}
