package com.digiwin.athena.kmservice.configuration;

import com.digiwin.athena.kmservice.configuration.mongoConvert.ComponentRead;
import com.digiwin.athena.kmservice.configuration.mongoConvert.ComponentWrite;
import com.digiwin.athena.kmservice.configuration.mongoConvert.MechanismCapacityReadConverter;
import com.digiwin.athena.kmservice.configuration.mongoConvert.StructuredComponentRead;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.config.MongoConfigurationSupport;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;

import java.util.ArrayList;
import java.util.List;

@Configuration
public class MongoConfiguration extends MongoConfigurationSupport {

    @Value("${spring.data.mongodb.database:null}")
    private String database;

    @Value("${spring.data.mongodb.databaseTenant:null}")
    private String databaseTenant;

    @Primary
    @Bean
    public MongoClientOptions mongoClientOptions0() {
        MongoClientOptions.Builder builder = new MongoClientOptions.Builder();
        builder.connectionsPerHost(500);
        builder.threadsAllowedToBlockForConnectionMultiplier(10);
        builder.maxWaitTime(60000);
        builder.connectTimeout(10000);
        builder.maxConnectionLifeTime(5*60*1000);
        return builder.build();
    }

    @Bean
    @Primary
    public MongoTemplate mongoTemplate(MongoClient mongo) throws Exception {
        SimpleMongoDbFactory mongoDbFactory = new SimpleMongoDbFactory(mongo, getDatabaseName());
        System.out.println("systemdb...." + mongoDbFactory.getDb().getName());
        return new MongoTemplate(mongoDbFactory, mappingMongoConverterSystem(mongoDbFactory));
    }


    @Bean
    @ConditionalOnProperty(prefix = "spring.data.mongodb",name = "databaseTenant")
    public MongoTemplate mongoTemplateTenant(MongoClient mongo) throws Exception {
        SimpleMongoDbFactory mongoDbFactory = new SimpleMongoDbFactory(mongo, getDatabaseTenantName());
        System.out.println("tenantdb...." + mongoDbFactory.getDb().getName());
        return new MongoTemplate(mongoDbFactory, mappingMongoConverterSystem(mongoDbFactory));
    }

    @Bean
    public MappingMongoConverter mappingMongoConverterSystem(MongoDbFactory mongoDbFactory) throws Exception {

        DbRefResolver dbRefResolver = new DefaultDbRefResolver(mongoDbFactory);
        MappingMongoConverter converter = new MappingMongoConverter(dbRefResolver, mongoMappingContext());
        converter.setCustomConversions(customConversionsFirst());
        return converter;
    }

    @Bean
    public CustomConversions customConversionsFirst() {
        List<Converter<?, ?>> converterList = new ArrayList<Converter<?, ?>>();
        converterList.add(new ComponentRead());
        converterList.add(new StructuredComponentRead());
        converterList.add(new ComponentWrite());
        converterList.add(new MechanismCapacityReadConverter());
        return new MongoCustomConversions(converterList);
    }

    @Override
    protected String getDatabaseName() {
        return database;
    }

    protected String getDatabaseTenantName() {
        return databaseTenant;
    }
}
