/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.configuration;

import com.digiwin.app.eai.DWEAIProperties;
import com.digiwin.athena.kmservice.support.KmRestTemplate;
import com.digiwin.http.client.DWHttpClientProperties;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.spring.util.JaSpringAopUtil;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class CommonRestTemplateConfiguration
implements SmartInitializingSingleton {
    @Autowired(required=false)
    @Qualifier(value="dwAttemptHttpLoadbalanceRoute")
    HttpRoutePlanner httpRoutePlanner;

    @Primary
    @Bean
    public KmRestTemplate commonRestTemplate() {
        KmRestTemplate restTemplate = this.createTemplate();
        ArrayList<AttachAppInfoInterceptor> interceptorList = new ArrayList<AttachAppInfoInterceptor>();
        interceptorList.add(new AttachAppInfoInterceptor());
        restTemplate.setInterceptors(interceptorList);
        return restTemplate;
    }

    @Bean(name={"simpleRestTemplate"})
    public RestTemplate simpleRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        ArrayList<AttachAppInfoInterceptor> interceptorList = new ArrayList<AttachAppInfoInterceptor>();
        interceptorList.add(new AttachAppInfoInterceptor());
        restTemplate.setInterceptors(interceptorList);
        return restTemplate;
    }

    private KmRestTemplate createTemplate() {
        DWEAIProperties dweaiProperties = new DWEAIProperties();
        dweaiProperties.setRestfulServiceBasePath("");
        DWEAIProperties.setProperties((DWEAIProperties)dweaiProperties);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (null != this.httpRoutePlanner) {
            httpClientBuilder.setRoutePlanner(this.httpRoutePlanner);
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(1024);
        connectionManager.setDefaultMaxPerRoute(256);
        connectionManager.setValidateAfterInactivity(30000);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        CloseableHttpClient httpClient = httpClientBuilder.build();
        KmRestTemplate restTemplate = new KmRestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient));
        restTemplate.setConnectionManager(connectionManager);
        return restTemplate;
    }

    public void afterSingletonsInstantiated() {
        List beanList = JaSpringBeanUtil.getBeanList(RestTemplate.class);
        if (JaCollectionUtil.isNotEmpty((Collection)beanList)) {
            beanList.forEach(restTemplate -> ((RestTemplate)JaSpringAopUtil.getSingletonTarget((Object)restTemplate)).getInterceptors().add(0, new AttachAppInfoInterceptor()));
        }
    }

    public static class AttachAppInfoInterceptor
    implements ClientHttpRequestInterceptor {
        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            AttachAppInfoInterceptor.attachAppAuthInfo(request.getURI().getHost(), request);
            return execution.execute(request, body);
        }

        public static void attachAppAuthInfo(String host, HttpRequest request) {
            String apToken;
            HttpHeaders httpHeaders = request.getHeaders();
            if (!httpHeaders.containsKey((Object)"digi-middleware-auth-app") && (apToken = DWHttpClientProperties.getProperties().getIamApToken()) != null && !apToken.isEmpty()) {
                httpHeaders.add("digi-middleware-auth-app", apToken);
            }
        }
    }
}

