/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.dtd;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.erp.Erp2FormInfo;
import com.digiwin.athena.domain.erp.ErpSyncRecord;
import com.digiwin.athena.domain.plugin.PluginBinding;
import com.digiwin.athena.dto.TaskSchedule;
import com.digiwin.athena.kmservice.constants.DataMapDb;
import com.digiwin.athena.kmservice.service.DataPickService;
import com.digiwin.athena.kmservice.service.KmApplicationService;
import com.digiwin.athena.kmservice.service.KmTenantService;
import com.digiwin.athena.mechanism.achivebo.MechanismDecision;
import com.digiwin.athena.mechanism.achivebo.MechanismDecisionTarget;
import com.digiwin.athena.mechanism.plugins.PluginRecord;
import com.mongodb.MongoClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.stereotype.Service;

@Service(value="dataMapDataPickService")
public class DataMapDataPickService
extends DataPickService
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataMapDataPickService.class);
    MongoTemplate datamapMongoTemplate;
    MongoTemplate datamapTenantMongoTemplate;
    @Autowired
    MongoClient mongo;
    @Autowired
    @Qualifier(value="mappingMongoConverterSystem")
    MappingMongoConverter mappingMongoConverterSystem;
    @Autowired
    private KmTenantService kmTenantService;
    @Autowired
    KmApplicationService kmApplicationService;
    public static List<Class> tenantClasses = Arrays.asList(ErpSyncRecord.class, TaskSchedule.class, MechanismDecision.class, MechanismDecisionTarget.class, PluginRecord.class, PluginBinding.class);
    public static List<Class> sysClasses = Arrays.asList(Erp2FormInfo.class);

    @Override
    public MongoTemplate systemTemplate() {
        return this.datamapMongoTemplate;
    }

    @Override
    public MongoTemplate tenantTemplate() {
        return this.datamapTenantMongoTemplate;
    }

    @Override
    public String tenantVersion(String tenantId) {
        return this.kmTenantService.getTenantVersion(tenantId);
    }

    @Override
    public List<String> getCodeByTypeAndAppCode(String type, String app) {
        List<String> codes = new ArrayList<String>();
        try {
            String version = this.tenantVersion();
            codes = this.kmApplicationService.getCodeByTypeAndAppCodeAndVersion(type, app, version);
        }
        catch (DWBusinessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return codes;
    }

    @Override
    public boolean isTenantCol(Class c) {
        return tenantClasses.contains(c);
    }

    @Override
    public boolean isSystemCol(Class c) {
        return sysClasses.contains(c);
    }

    public void afterPropertiesSet() throws Exception {
        SimpleMongoDbFactory mongoDbFactory = new SimpleMongoDbFactory(this.mongo, DataMapDb.DATAMAP.getValue());
        this.datamapMongoTemplate = new MongoTemplate((MongoDbFactory)mongoDbFactory, (MongoConverter)this.mappingMongoConverterSystem);
        SimpleMongoDbFactory mongoDbFactoryTenant = new SimpleMongoDbFactory(this.mongo, DataMapDb.DATAMAPTENANT.getValue());
        this.datamapTenantMongoTemplate = new MongoTemplate((MongoDbFactory)mongoDbFactoryTenant, (MongoConverter)this.mappingMongoConverterSystem);
    }
}

