package com.digiwin.athena.kmservice.analysis;

import com.digiwin.athena.kmservice.configuration.MongoConfiguration;
import com.digiwin.athena.kmservice.support.KmRestTemplate;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.internal.session.ServerSessionPool;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

@Component
public class AnalysisComponent  {

    @Autowired
    KmRestTemplate kmRestTemplate;
    @Autowired
    UriAnalysisFilter uriAnalysisFilter;
    @Autowired
    MongoClient mongoClient;


    public UriAnalysisBean commonRestTemplateStatics(){
        PoolingHttpClientConnectionManager connectionManager = kmRestTemplate.getConnectionManager();
        UriAnalysisBean uriAnalysisBean = new UriAnalysisBean();
        PoolStats total = connectionManager.getTotalStats();
        uriAnalysisBean.setMax(total.getMax());
        uriAnalysisBean.setLeased(total.getLeased());
        uriAnalysisBean.setPending(total.getPending());
        uriAnalysisBean.setAvailable(total.getAvailable());
        Map<String, PoolStats> statsMap = new HashMap<>();
        for(HttpRoute route:connectionManager.getRoutes()){
            PoolStats routeStats = connectionManager.getStats(route);
            statsMap.put(route.getTargetHost().getHostName(),routeStats);
        }
        uriAnalysisBean.setExt(statsMap);
        return uriAnalysisBean;
    }

    public Map<String,Object> mongoStatics(){
        Map<String,Object> result = new HashMap<>();
        MongoClientOptions options =mongoClient.getMongoClientOptions();
        result.put("options",options.toString());
        result.put("queued", MongoConfiguration.waitQueue.get());
        result.put("pooled",MongoConfiguration.connect.get());
        result.put("leased",MongoConfiguration.connectCheck.get());
        return result;
    }


    public Map<String,Object> allAnalysisInfo(){
        Map<String,Object> result = new HashMap<>();
        Map<String, UriAnalysisBean> uriInfo = uriAnalysisFilter.uriAnalysisBeanMap();
        Map<String,Object> jvmInfo = AnalysisTool.jvmInfo();
        result.put("requestInfo",uriInfo);
        result.put("jvmInfo",jvmInfo);
        result.put("commonRestTemplate",commonRestTemplateStatics());
        result.put("mongo",mongoStatics());
        return result;
    }

}
