package com.digiwin.athena.kmservice.analysis;

import com.alibaba.fastjson.JSON;

import java.lang.management.*;
import java.util.*;


public class AnalysisTool {


    public static Map<String,Object> jvmInfo(){
        Map<String,Object> info = new HashMap<>();
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        info.put("os.name",operatingSystemMXBean.getName());
        info.put("os.arch",operatingSystemMXBean.getArch());
        info.put("os.version",operatingSystemMXBean.getVersion());
        info.put("os.cores",operatingSystemMXBean.getAvailableProcessors());
        info.put("os.loadAverage",operatingSystemMXBean.getSystemLoadAverage());
        info.put("mem.heapMemoryUsage",memoryMXBean.getHeapMemoryUsage());
        info.put("mem.nonHeapMemoryUsage",memoryMXBean.getNonHeapMemoryUsage());

        Map<String,Object> poolmems = new HashMap<>();
        for(MemoryPoolMXBean poolMXBean:memoryPoolMXBeans){
            Map<String,Object> detail = new HashMap<>();
            detail.put("type",poolMXBean.getType());
            detail.put("usage",poolMXBean.getUsage());
            poolmems.put(poolMXBean.getName(), detail);
        }
        info.put("mem.pools",poolmems);

        Map<String,Object> gcs = new HashMap<>();
        for(GarbageCollectorMXBean collectorMXBean:garbageCollectorMXBeans){
            Map<String,Object> detail = new HashMap<>();
            detail.put("count",collectorMXBean.getCollectionCount());
            detail.put("time",collectorMXBean.getCollectionTime());
            gcs.put(collectorMXBean.getName(),detail);
        }
        info.put("mem.gcInfo",gcs);

        info.put("thread.totalStartedThreadCount",threadMXBean.getTotalStartedThreadCount());
        info.put("thread.threadCount",threadMXBean.getThreadCount());
        info.put("thread.peakThreadCount",threadMXBean.getPeakThreadCount());
        info.put("thread.daemonThreadCount",threadMXBean.getDaemonThreadCount());


        long[] lockedIds = threadMXBean.findDeadlockedThreads();
        if(null!=lockedIds){
            List<Map<String,Object>> deadlocks = new ArrayList<>();
            for(long id:lockedIds){
                Map<String,Object> detail = new HashMap<>();
                detail.put("id",id);
                ThreadInfo ti = threadMXBean.getThreadInfo(id);
                detail.put("name",ti.getThreadName());
                detail.put("trace",traceToString(ti.getStackTrace()));
                deadlocks.add(detail);
            }
            info.put("deadLocks",deadlocks);
        }


        List<Map<String,Object>> top10 = new ArrayList<>();
      //  ThreadInfo[] infos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds());
        ThreadInfo[] infos = threadMXBean.dumpAllThreads(true,true);
        Arrays.sort(infos,Comparator.comparing(in->threadMXBean.getThreadCpuTime(in.getThreadId())));
        int count = infos.length;
        int ten =Math.min(10,count);
        for(int i=count;i>count-ten;){
            ThreadInfo ti = infos[--i];
            Map<String,Object> detail = new HashMap<>();
            detail.put("id",ti.getThreadId());
            detail.put("name",ti.getThreadName());
            detail.put("trace",traceToString(ti.getStackTrace()));
            detail.put("cpuTime",threadMXBean.getThreadCpuTime(ti.getThreadId()));
            top10.add(detail);
        }

        info.put("thread.top10",top10);
        return info;
    }


    public static List<Map<String,Object>> threadDump(){
        List<Map<String,Object>> list = new ArrayList<>();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] infos =threadMXBean.dumpAllThreads(true,true);
        for(ThreadInfo info:infos){
            Map<String,Object> detail= new HashMap<>();
            detail.put("id",info.getThreadId());
            detail.put("name",info.getThreadName());
            detail.put("trace",traceToString(info.getStackTrace()));
            detail.put("cpuTime",threadMXBean.getThreadCpuTime(info.getThreadId()));
            list.add(detail);
        }

        return list;
    }



   static String  traceToString(StackTraceElement[] traceElements){
        StringBuilder stringBuilder = new StringBuilder();
        for(StackTraceElement element :traceElements){
            stringBuilder.append(element.toString()).append("\n");
        }
        return stringBuilder.toString();
    }


    public static void main(String[] args) {
        Object obj = jvmInfo();
       // Object obj = threadDump();
        System.out.println(JSON.toJSONString(obj,true));
    }

}
