package com.digiwin.athena.kmservice.locale;


import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.kmservice.utils.TranslateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Slf4j
@Order(200)
public class LangAspect {

    private final ThreadLocal<Integer> langHandle = new ThreadLocal<>();

    @Pointcut("@within(com.digiwin.athena.kmservice.locale.Lang)")
    public void pointcut1() {
    }

    @Pointcut("@annotation(com.digiwin.athena.kmservice.locale.Lang)")
    public void pointcut2() {
    }

    @Around("pointcut1() || pointcut2()")
    public Object processLang(ProceedingJoinPoint jp) throws Throwable {
        try {
            return doProcessLang(jp);
        } finally {
            if (null != langHandle.get() && langHandle.get() == 0) {
                langHandle.remove();
            }
        }
    }

    private Object doProcessLang(ProceedingJoinPoint jp) throws Throwable {
        Integer count =langHandle.get();
        if(null==count){
            count=1;
        }else{
            count = count+1;
        }
        langHandle.set(count);
        Object result;
        try {
            result = jp.proceed();
        } catch (Throwable e) {
            langHandle.set(--count);
            throw e;
        }
        Integer count2 = langHandle.get();
        langHandle.set(--count2);
        String lang = ServiceUtils.getLocale();
        if(langHandle.get()>0 || StringUtils.isEmpty(lang)){
            return result;
        }
        TranslateUtil.dealLangRecusive(result,lang);
        return result;
    }

}
