/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.configuration;

import com.digiwin.athena.kmservice.configuration.mongoConvert.ComponentRead;
import com.digiwin.athena.kmservice.configuration.mongoConvert.ComponentWrite;
import com.digiwin.athena.kmservice.configuration.mongoConvert.MechanismCapacityReadConverter;
import com.digiwin.athena.kmservice.configuration.mongoConvert.StructuredComponentRead;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.event.ConnectionAddedEvent;
import com.mongodb.event.ConnectionCheckedInEvent;
import com.mongodb.event.ConnectionCheckedOutEvent;
import com.mongodb.event.ConnectionPoolClosedEvent;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.event.ConnectionPoolOpenedEvent;
import com.mongodb.event.ConnectionPoolWaitQueueEnteredEvent;
import com.mongodb.event.ConnectionPoolWaitQueueExitedEvent;
import com.mongodb.event.ConnectionRemovedEvent;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.config.MongoConfigurationSupport;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoCustomConversions;

@Configuration
public class MongoConfiguration
extends MongoConfigurationSupport {
    @Value(value="${spring.data.mongodb.database:null}")
    private String database;
    @Value(value="${spring.data.mongodb.databaseTenant:null}")
    private String databaseTenant;
    public static AtomicLong connectCheck = new AtomicLong();
    public static AtomicLong connect = new AtomicLong();
    public static AtomicLong waitQueue = new AtomicLong();

    @Primary
    @Bean
    public MongoClientOptions mongoClientOptions0() {
        MongoClientOptions.Builder builder = new MongoClientOptions.Builder();
        builder.connectionsPerHost(500);
        builder.threadsAllowedToBlockForConnectionMultiplier(10);
        builder.maxWaitTime(60000);
        builder.connectTimeout(10000);
        builder.maxConnectionLifeTime(300000);
        builder.addConnectionPoolListener(new ConnectionPoolListener(){

            public void connectionPoolOpened(ConnectionPoolOpenedEvent event) {
                System.out.println("mongo pool opened " + event.getServerId());
            }

            public void connectionPoolClosed(ConnectionPoolClosedEvent event) {
                System.out.println("mongo pool closed " + event.getServerId());
            }

            public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
                connectCheck.incrementAndGet();
            }

            public void connectionCheckedIn(ConnectionCheckedInEvent event) {
                connectCheck.decrementAndGet();
            }

            public void waitQueueEntered(ConnectionPoolWaitQueueEnteredEvent event) {
                waitQueue.incrementAndGet();
            }

            public void waitQueueExited(ConnectionPoolWaitQueueExitedEvent event) {
                waitQueue.decrementAndGet();
            }

            public void connectionAdded(ConnectionAddedEvent event) {
                connect.incrementAndGet();
            }

            public void connectionRemoved(ConnectionRemovedEvent event) {
                connect.decrementAndGet();
            }
        });
        return builder.build();
    }

    @Bean
    @Primary
    public MongoTemplate mongoTemplate(MongoClient mongo) throws Exception {
        SimpleMongoDbFactory mongoDbFactory = new SimpleMongoDbFactory(mongo, this.getDatabaseName());
        System.out.println("systemdb...." + mongoDbFactory.getDb().getName());
        return new MongoTemplate((MongoDbFactory)mongoDbFactory, (MongoConverter)this.mappingMongoConverterSystem((MongoDbFactory)mongoDbFactory));
    }

    @Bean
    @ConditionalOnProperty(prefix="spring.data.mongodb", name={"databaseTenant"})
    public MongoTemplate mongoTemplateTenant(MongoClient mongo) throws Exception {
        SimpleMongoDbFactory mongoDbFactory = new SimpleMongoDbFactory(mongo, this.getDatabaseTenantName());
        System.out.println("tenantdb...." + mongoDbFactory.getDb().getName());
        return new MongoTemplate((MongoDbFactory)mongoDbFactory, (MongoConverter)this.mappingMongoConverterSystem((MongoDbFactory)mongoDbFactory));
    }

    @Bean
    public MappingMongoConverter mappingMongoConverterSystem(MongoDbFactory mongoDbFactory) throws Exception {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(mongoDbFactory);
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)this.mongoMappingContext());
        converter.setCustomConversions(this.customConversionsFirst());
        return converter;
    }

    @Bean
    public CustomConversions customConversionsFirst() {
        ArrayList<Object> converterList = new ArrayList<Object>();
        converterList.add(new ComponentRead());
        converterList.add(new StructuredComponentRead());
        converterList.add(new ComponentWrite());
        converterList.add(new MechanismCapacityReadConverter());
        return new MongoCustomConversions(converterList);
    }

    protected String getDatabaseName() {
        return this.database;
    }

    protected String getDatabaseTenantName() {
        return this.databaseTenant;
    }
}

