/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.service;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.domain.core.Task;
import com.digiwin.athena.domain.core.TenantObjectAdaptation;
import com.digiwin.athena.dto.BaseCondition;
import com.digiwin.athena.dto.BasicQuery;
import com.digiwin.athena.kmservice.utils.EocUtils;
import com.digiwin.athena.kmservice.utils.IAMUtils;
import com.digiwin.athena.kmservice.utils.MergeUtil;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.mechanism.bo.HookBO;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;

public abstract class DataPickService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataPickService.class);
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected StringRedisTemplate stringRedisTemplate;
    @Autowired
    IAMUtils iamUtils;
    @Autowired
    EocUtils eocUtils;
    public static String KmRebuildDoubleWriteKey = "DatamapRebuildDoubleWriteKey";

    public <T extends TenantObject> T findByCode(String code, Class<T> c) throws DWBusinessException {
        BasicQuery request = new BasicQuery();
        request.setQuery(new HashMap());
        request.getQuery().put("code", code);
        T t = this.findOne(request, c);
        return t;
    }

    public <T extends TenantObject> List<T> findByCodes(Collection<String> codes, Class<T> c) throws DWBusinessException {
        BasicQuery request = new BasicQuery();
        request.setQuery(new HashMap());
        request.getQuery().put("code", codes);
        List<T> ts = this.find(request, c);
        return ts;
    }

    public <T extends TenantObject> T findOne(BasicQuery request, Class<T> c) throws DWBusinessException {
        List<T> ts = this.find(request, c);
        if (!ts.isEmpty()) {
            return (T)((TenantObject)ts.get(0));
        }
        return null;
    }

    public <T extends TenantObject> List<T> find(BasicQuery request, Class<T> c) throws DWBusinessException {
        return this.find(request, c, null, false);
    }

    public <T extends TenantObject> List<T> find(BasicQuery request, Class<T> c, String col, boolean systemOnly) throws DWBusinessException {
        List ts = new ArrayList();
        Map<String, Object> eocInfo = request.getEocInfo();
        if (CollectionUtils.isEmpty((Map)eocInfo)) {
            eocInfo = ServiceUtils.getContext().getEocInfo();
        }
        if (!this.isTenantCol(c)) {
            List systems = null;
            Query systemQuery = this.buildSystemQuery(request, c);
            systems = StringUtils.isNotEmpty((CharSequence)col) ? this.systemTemplate().find(systemQuery, c, col) : this.systemTemplate().find(systemQuery, c);
            ts.addAll(systems);
        }
        if (!this.isSystemCol(c) && !systemOnly) {
            List users = null;
            Query queryUser = this.buildTenantQuery(request, c, eocInfo);
            users = StringUtils.isNotEmpty((CharSequence)col) ? this.tenantTemplate().find(queryUser, c, col) : this.tenantTemplate().find(queryUser, c, this.tenantCol(c));
            this.sortTenantList(users);
            ts.addAll(users);
        }
        ts = MergeUtil.excludeSameCode(ts, c, eocInfo);
        return ts;
    }

    public <T extends TenantObject> long remove(BasicQuery request, Class<T> c) throws DWBusinessException {
        Query queryUser = this.buildTenantQuery(request, c, request.getEocInfo());
        DeleteResult remove = this.tenantTemplate().remove(queryUser, c, this.tenantCol(c));
        return remove.getDeletedCount();
    }

    public <T extends TenantObject> long update(BasicQuery request, Class<T> c) throws DWBusinessException {
        if (CollectionUtils.isEmpty((Map)request.getData())) {
            return 0L;
        }
        Query queryUser = this.buildTenantQuery(request, c, request.getEocInfo());
        Update update = new Update();
        request.getData().forEach((arg_0, arg_1) -> ((Update)update).set(arg_0, arg_1));
        UpdateResult updated = this.tenantTemplate().updateMulti(queryUser, update, this.tenantCol(c));
        return updated.getModifiedCount();
    }

    private <T extends TenantObject> void sortTenantList(List<T> ts) {
        try {
            if (CollectionUtils.isEmpty(ts) || ts.size() <= 1) {
                return;
            }
            Collections.sort(ts, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    Long time1 = DataPickService.getTimeById(o1.getId());
                    Long time2 = DataPickService.getTimeById(o2.getId());
                    if (time1 > time2) {
                        return -1;
                    }
                    if (time1 < time2) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Long getTimeById(String id) {
        ObjectId objectId = new ObjectId(id);
        return objectId.getDate().getTime();
    }

    public Query buildSystemQuery(BasicQuery request, Class c) throws DWBusinessException {
        Query query = this.buildQuery(request, c);
        String tenantId = ServiceUtils.getTenantIdSilent();
        if (null != tenantId) {
            String version = this.tenantVersion();
            ArrayList<String> tenantIds = new ArrayList<String>();
            tenantIds.add(tenantId);
            tenantIds.add("SYSTEM");
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").in(tenantIds));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)version));
        }
        return query;
    }

    public Query buildTenantQuery(BasicQuery request, Class c, Map<String, Object> eocInfo) throws DWBusinessException {
        this.processOperateUnit(request, eocInfo);
        Query query = this.buildQuery(request, c);
        String tenantId = ServiceUtils.getTenantIdSilent();
        if (null != tenantId) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId));
        }
        return query;
    }

    private void processOperateUnit(BasicQuery request, Map<String, Object> eocInfo) throws DWBusinessException {
        if (this.iamUtils.isTenantOperationUnitV2()) {
            eocInfo = eocInfo == null ? new HashMap<String, String>() : eocInfo;
            Object operateUnitId = JSONPath.eval(eocInfo, (String)"$.operation_unit_v2.eoc_mapping_id");
            Map headers = DWServiceContext.getContext().getRequestHeader();
            String token = MapUtils.getString((Map)headers, (Object)"token");
            if (operateUnitId != null) {
                String operationPath = this.eocUtils.getOperationUnitPath(token, operateUnitId.toString());
                if (StringUtils.isNotBlank((CharSequence)operationPath)) {
                    request.getQuery().put("eocInfo.operation_unit_v2.eoc_mapping_id", Arrays.asList(operationPath.split(":")));
                    eocInfo.put("operationPath", operationPath);
                } else {
                    request.getQuery().put("eocInfo", null);
                }
            } else {
                String rootOperationUnitId = this.eocUtils.getRootOperationUnitId(token);
                if (StringUtils.isNotBlank((CharSequence)rootOperationUnitId)) {
                    request.getQuery().put("eocInfo.operation_unit_v2.eoc_mapping_id", rootOperationUnitId);
                    eocInfo.put("operationPath", rootOperationUnitId);
                } else {
                    request.getQuery().put("eocInfo", null);
                }
            }
        }
    }

    public Query buildQuery(BasicQuery request, Class c) {
        Query query = new Query();
        if (null != request.getQuery()) {
            this.processApplicationParam(request.getQuery(), c);
            request.getQuery().forEach((k, v) -> {
                if (v instanceof Collection) {
                    Collection collection = (Collection)v;
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)k).in(collection));
                } else if (v instanceof Criteria) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)k).elemMatch((Criteria)v));
                } else if ("name".equalsIgnoreCase((String)k) && v instanceof String) {
                    String sv = (String)v;
                    Criteria nameCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"name").regex(sv), Criteria.where((String)"lang.name.zh_CN").regex(sv), Criteria.where((String)"lang.name.zh_TW").regex(sv), Criteria.where((String)"lang.name.en_US").regex(sv)});
                    query.addCriteria((CriteriaDefinition)nameCriteria);
                } else {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)k).is(v));
                }
            });
        } else if (null != request.getCondition()) {
            query.addCriteria((CriteriaDefinition)DataPickService.buildCriteria(request.getCondition()));
        }
        if (null != request.getPage() && null != request.getPageSize()) {
            query.with((Pageable)PageRequest.of((int)request.getPage(), (int)request.getPageSize()));
        }
        if (CollectionUtil.isNotEmpty((Collection)request.getSortFields())) {
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (Object field : request.getSortFields()) {
                Sort.Direction direction = "desc".equalsIgnoreCase(field.getDirection()) ? Sort.Direction.DESC : Sort.Direction.ASC;
                Sort.Order order = new Sort.Order(direction, field.getField());
                orders.add(order);
            }
            query.with(Sort.by(orders));
        }
        if (CollectionUtil.isNotEmpty((Collection)request.getReturnFields())) {
            ArrayList<String> newReturnFields = new ArrayList<String>(request.getReturnFields());
            newReturnFields.add("code");
            newReturnFields.add("tenantId");
            newReturnFields.add("version");
            request.setReturnFields(newReturnFields);
            for (Object field : request.getReturnFields()) {
                query.fields().include((String)field);
            }
        }
        return query;
    }

    public String tenantVersion() throws DWBusinessException {
        String localKey = "TenantVersion";
        String version = (String)ServiceUtils.getContext().getProfiles().get(localKey);
        if (null != version) {
            return version;
        }
        String tenantId = ServiceUtils.getTenantId();
        String cacheKey = "knowledgegraph:SYSTEM:" + tenantId + ":" + localKey;
        version = (String)this.stringRedisTemplate.opsForValue().get((Object)cacheKey);
        if (null != version) {
            ServiceUtils.getContext().getProfiles().put(localKey, version);
            return version;
        }
        version = this.tenantVersion(tenantId);
        if (null == version) {
            version = "2.0";
        }
        ServiceUtils.getContext().getProfiles().put(localKey, version);
        this.stringRedisTemplate.opsForValue().set((Object)cacheKey, (Object)version, 7200L, TimeUnit.SECONDS);
        return version;
    }

    public String tenantCol(Class c) {
        String col = this.systemTemplate().getCollectionName(c);
        return col;
    }

    public <T> T convert(Object obj, Class<T> c) {
        Object t = this.objectMapper.convertValue(obj, c);
        return (T)t;
    }

    public <T extends TenantObject> void save(T t, Class<T> c) {
        try {
            T toSave = this.tenantObjectToSave(t, c);
            this.saveTenantObject(toSave, c);
        }
        catch (DWBusinessException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends TenantObject> T tenantObjectToSave(T t, Class<T> c) throws DWBusinessException {
        if (null == t || null == t.getCode()) {
            return null;
        }
        String tenantId = ServiceUtils.getTenantId();
        t.setId(null);
        t.setSourceLevel(null);
        t.setSourceId(null);
        t.setAthena_namespace(null);
        t.setTenantId(tenantId);
        if (!"SYSTEM".equalsIgnoreCase(tenantId)) {
            t.setLang(null);
        }
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)t.getCode());
        criteria = this.addEocInfoToCriteria(t.getEocInfo(), criteria);
        Query query = Query.query((CriteriaDefinition)criteria);
        TenantObject toSave = null;
        List ts = this.tenantTemplate().find(query, c, this.tenantCol(c));
        this.sortTenantList(ts);
        if (!ts.isEmpty()) {
            for (TenantObject tt : ts) {
                if (!StringUtils.isEmpty((CharSequence)tt.getPluginId())) continue;
                toSave = tt;
            }
        }
        if (null == toSave) {
            toSave = t;
        } else {
            MergeUtil.mergeObject(t, toSave);
        }
        return (T)toSave;
    }

    public <T extends TenantObject> void saveTenantObject(T t, Class<T> c) {
        t.setUserEdit(Boolean.valueOf(true));
        t.setObjUpdateTime(Long.valueOf(System.currentTimeMillis()));
        this.tenantTemplate().save(t, this.tenantCol(c));
    }

    public Criteria addEocInfoToCriteria(Map<String, Object> eocInfo, Criteria criteria) {
        if (this.iamUtils.isTenantOperationUnitV2()) {
            Object eval = JSONPath.eval(eocInfo, (String)"$.operation_unit_v2.eoc_mapping_id");
            criteria = new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"eocInfo.operation_unit_v2.eoc_mapping_id").is((Object)(eval != null ? String.valueOf(eval) : null))});
            return criteria;
        }
        String companyId = null;
        String siteId = null;
        String regionId = null;
        if (eocInfo != null) {
            companyId = MapUtils.getString(eocInfo, (Object)"eoc_company_id");
            siteId = MapUtils.getString(eocInfo, (Object)"eoc_site_id");
            regionId = MapUtils.getString(eocInfo, (Object)"eoc_region_id");
        }
        criteria = StringUtils.isNotEmpty(companyId) ? new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"eocInfo.eoc_company_id").is((Object)companyId)}) : new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"eocInfo.eoc_company_id").is(null)});
        criteria = StringUtils.isNotEmpty((CharSequence)siteId) ? new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"eocInfo.eoc_site_id").is((Object)siteId)}) : new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"eocInfo.eoc_site_id").is(null)});
        criteria = StringUtils.isNotEmpty((CharSequence)regionId) ? new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"eocInfo.eoc_region_id").is((Object)regionId)}) : new Criteria().andOperator(new Criteria[]{criteria, Criteria.where((String)"eocInfo.eoc_region_id").is(null)});
        return criteria;
    }

    public void processApplicationParam(Map<String, Object> query, Class clazz) {
        List<String> codes;
        if (null == query || null == clazz) {
            return;
        }
        String type = null;
        if (clazz.isAssignableFrom(Project.class)) {
            type = "task";
        } else if (clazz.isAssignableFrom(Task.class)) {
            type = "activity";
        } else {
            return;
        }
        String appCode = (String)query.get("application");
        Object primaryCode = query.get("code");
        if (null != appCode && null == primaryCode && !CollectionUtils.isEmpty(codes = this.getCodeByTypeAndAppCode(type, appCode))) {
            query.put("code", codes);
            query.remove("application");
        }
    }

    public <T extends TenantObject> T findBetter(String code, Class<T> c) throws DWBusinessException {
        T t = this.findByCode(code, c);
        t = this.mergeWithAdaption(t, c);
        return t;
    }

    public <T extends TenantObject> T findBetter(BasicQuery request, Class<T> c) throws DWBusinessException {
        T t = this.findOne(request, c);
        t = this.mergeWithAdaption(t, c);
        return t;
    }

    public <T extends TenantObject> List<T> findBetters(BasicQuery request, Class<T> c) throws DWBusinessException {
        List<T> ts = this.find(request, c);
        ts = this.mergeWithAdaption(ts, c);
        return ts;
    }

    public <T extends TenantObject> T mergeWithAdaption(T obj, Class<T> c) throws DWBusinessException {
        T t = obj;
        if (null != t) {
            String tenantId = ServiceUtils.getTenantId();
            String table = DataPickService.tableTenantObjectAdaptation(c);
            Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)t.getCode());
            Query query = Query.query((CriteriaDefinition)criteria);
            List adaptations = this.tenantTemplate().find(query, TenantObjectAdaptation.class, table);
            for (TenantObjectAdaptation each : adaptations) {
                t = this.mergeAdaption(each, t, c);
            }
        }
        return t;
    }

    public <T extends TenantObject> List<T> mergeWithAdaption(List<T> list, Class<T> c) throws DWBusinessException {
        List<TenantObject> ts = list;
        if (!CollectionUtils.isEmpty(ts)) {
            String tenantId = ServiceUtils.getTenantId();
            HashMap<String, TenantObject> tsMap = new HashMap<String, TenantObject>();
            ts.forEach(t -> tsMap.put(t.getCode(), (TenantObject)t));
            String table = DataPickService.tableTenantObjectAdaptation(c);
            Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("code").in(tsMap.keySet());
            Query query = Query.query((CriteriaDefinition)criteria);
            List adaptations = this.tenantTemplate().find(query, TenantObjectAdaptation.class, table);
            for (TenantObjectAdaptation ta : adaptations) {
                TenantObject t2;
                TenantObject t22 = this.mergeAdaption(ta, t2 = (TenantObject)tsMap.get(ta.getCode()), c);
                if (null == t22) continue;
                tsMap.put(t2.getCode(), t22);
            }
            ts = new ArrayList<T>();
            ts.addAll(tsMap.values());
        }
        return ts;
    }

    private <T extends TenantObject> T mergeAdaption(TenantObjectAdaptation adaptation, T to, Class<T> c) {
        Object result = to;
        if (null == adaptation || null == to || null == adaptation.getPath()) {
            return result;
        }
        try {
            JSONObject jsonObjectV = JSON.parseObject((String)JSON.toJSONString(to));
            if ("array".equalsIgnoreCase(adaptation.getDateType()) && "add".equalsIgnoreCase(adaptation.getOp())) {
                if (null != adaptation.getValue()) {
                    JsonPath.parse((Object)jsonObjectV).add(adaptation.getPath(), adaptation.getValue(), new Predicate[0]);
                }
            } else if ("put".equalsIgnoreCase(adaptation.getOp())) {
                JsonPath.parse((Object)jsonObjectV).put(adaptation.getPath(), adaptation.getAttribute(), adaptation.getValue(), new Predicate[0]);
            } else if ("comb".equalsIgnoreCase(adaptation.getOp())) {
                try {
                    Object read = JsonPath.read((Object)jsonObjectV, (String)adaptation.getPath(), (Predicate[])new Predicate[0]);
                    JSONArray targetArray = JSONArray.parseArray((String)JSON.toJSONString((Object)read));
                    if (targetArray.isEmpty()) {
                        targetArray.addAll((Collection)JSONArray.parseArray((String)JSON.toJSONString((Object)adaptation.getValue())));
                    } else {
                        JSONArray sourceArray = JSONArray.parseArray((String)JSON.toJSONString((Object)adaptation.getValue()));
                        for (int i = 0; i < sourceArray.size(); ++i) {
                            boolean flag = true;
                            JSONObject sourceObject = sourceArray.getJSONObject(i);
                            String sourceEventSource = sourceObject.getString("eventSource");
                            for (int j = 0; j < targetArray.size(); ++j) {
                                JSONObject targetObject = targetArray.getJSONObject(j);
                                String targetEventSource = targetObject.getString("eventSource");
                                if (!sourceEventSource.equals(targetEventSource)) continue;
                                HookBO sourceHookBO = (HookBO)JSONObject.parseObject((String)JSON.toJSONString((Object)sourceObject), HookBO.class);
                                HookBO targetHookBO = (HookBO)JSONObject.parseObject((String)JSON.toJSONString((Object)targetObject), HookBO.class);
                                MergeUtil.mergeObject(targetHookBO, sourceHookBO, HookBO.class, "^.*Hook", false);
                                targetArray.set(i, (Object)targetHookBO);
                                flag = false;
                                break;
                            }
                            if (!flag) continue;
                            targetArray.addAll((Collection)JSONArray.parseArray((String)JSON.toJSONString((Object)adaptation.getValue())));
                        }
                    }
                    adaptation.setValue((Object)targetArray);
                }
                catch (Exception e) {
                    log.warn("DataPickService.excludeSameCode \u8bfb\u53d6\u6570\u636e\u5931\u8d25\uff0ce={}", (Throwable)e);
                }
                JsonPath.parse((Object)jsonObjectV).set(adaptation.getPath(), adaptation.getValue(), new Predicate[0]);
            } else {
                JsonPath.parse((Object)jsonObjectV).set(adaptation.getPath(), adaptation.getValue(), new Predicate[0]);
                try {
                    if (((Boolean)JsonPath.parse((Object)jsonObjectV).read(adaptation.getPath(), new Predicate[0])).booleanValue()) {
                        log.info("\u8d4b\u503c\u6b63\u786e\uff01");
                    }
                }
                catch (Exception e) {
                    JsonPath.parse((Object)jsonObjectV).put("$", adaptation.getPath().replace("$.", ""), adaptation.getValue(), new Predicate[0]);
                }
            }
            result = (TenantObject)JSON.parseObject((String)JSON.toJSONString((Object)jsonObjectV), c);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static Criteria buildCriteria(BaseCondition condition) {
        Criteria criteria = new Criteria();
        if (null == condition || null == condition.getOp()) {
            return criteria;
        }
        if ("and".equalsIgnoreCase(condition.getOp())) {
            for (BaseCondition sub : condition.getConditions()) {
                criteria.andOperator(new Criteria[]{DataPickService.buildCriteria(sub)});
            }
        } else if ("or".equalsIgnoreCase(condition.getOp())) {
            for (BaseCondition sub : condition.getConditions()) {
                criteria.orOperator(new Criteria[]{DataPickService.buildCriteria(sub)});
            }
        } else {
            criteria = new Criteria(condition.getKey());
            switch (condition.getOp()) {
                case "eq": {
                    criteria.is(condition.getValue());
                    break;
                }
                case "ne": {
                    criteria.ne(condition.getValue());
                    break;
                }
                case "gt": {
                    criteria.gt(condition.getValue());
                    break;
                }
                case "gte": {
                    criteria.gte(condition.getValue());
                    break;
                }
                case "lt": {
                    criteria.lt(condition.getValue());
                    break;
                }
                case "lte": {
                    criteria.lte(condition.getValue());
                    break;
                }
                case "regex": {
                    criteria.regex((String)condition.getValue());
                    break;
                }
                case "in": {
                    criteria.in(new Object[]{condition.getValue()});
                    break;
                }
                case "nin": {
                    criteria.nin(new Object[]{condition.getValue()});
                    break;
                }
                case "isnull": {
                    criteria.is(null);
                    break;
                }
                case "notnull": {
                    criteria.ne(null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not support op " + condition.getOp());
                }
            }
        }
        return criteria;
    }

    public void setRootOperationUnitId(TenantObject tenantObject) throws DWBusinessException {
        Object eval;
        if (!this.iamUtils.isTenantOperationUnitV2()) {
            return;
        }
        if (MapUtils.isEmpty((Map)tenantObject.getEocInfo())) {
            tenantObject.setEocInfo(new HashMap());
        }
        if ((eval = JSONPath.eval((Object)tenantObject.getEocInfo(), (String)"$.operation_unit_v2.eoc_mapping_id")) != null) {
            return;
        }
        Map headers = DWServiceContext.getContext().getRequestHeader();
        String token = MapUtils.getString((Map)headers, (Object)"token");
        String id = this.eocUtils.getRootOperationUnitId(token);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            JSONObject operationUnitV2 = new JSONObject().fluentPut("eoc_mapping_id", (Object)id);
            tenantObject.getEocInfo().put("operation_unit_v2", operationUnitV2);
        }
    }

    public static String tableTenantObjectAdaptation(Class c) {
        return c.getSimpleName() + "Adaptation";
    }

    public abstract MongoTemplate systemTemplate();

    public abstract MongoTemplate tenantTemplate();

    public abstract String tenantVersion(String var1);

    public abstract List<String> getCodeByTypeAndAppCode(String var1, String var2);

    public abstract boolean isTenantCol(Class var1);

    public abstract boolean isSystemCol(Class var1);
}

