/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.utils;

import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.dto.FieldDataPrecision;
import com.digiwin.athena.dto.MultiLanguageDTO;
import com.digiwin.athena.dto.ProdType;
import com.digiwin.athena.kg.action.ActionMetadataDTO;
import com.digiwin.athena.kg.action.ApiDataFieldLocaleMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.kmservice.action.execution.ProductNameGetter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class MetadataTranslator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataTranslator.class);
    public static final String DESCRIPTION_FILED = "Description";
    public static final String REMARK_FILED = "Remark";

    public static void translateField(GetActionLocaleResponseDTO localeResponseDTO, ActionMetadataDTO responseDTO, String localeStr, ProductNameGetter productNameGetter) {
        List reqApiDataFieldLocaleMetadataDTOS = localeResponseDTO.getRequest().getParameters();
        String getLang = "get" + localeStr.substring(0, 1).toUpperCase() + localeStr.substring(1);
        if (null != reqApiDataFieldLocaleMetadataDTOS) {
            for (int i = 0; i < reqApiDataFieldLocaleMetadataDTOS.size(); ++i) {
                ApiDataFieldMetadataDTO requestParams = (ApiDataFieldMetadataDTO)responseDTO.getRequest().getParameters().get(i);
                ((ApiDataFieldLocaleMetadataDTO)reqApiDataFieldLocaleMetadataDTOS.get(i)).setDescription(MetadataTranslator.getTargetLang(getLang, requestParams, requestParams.getClass(), DESCRIPTION_FILED));
                ((ApiDataFieldLocaleMetadataDTO)reqApiDataFieldLocaleMetadataDTOS.get(i)).setRemark(MetadataTranslator.getTargetLang(getLang, requestParams, requestParams.getClass(), REMARK_FILED));
                List field = ((ApiDataFieldLocaleMetadataDTO)reqApiDataFieldLocaleMetadataDTOS.get(i)).getField();
                if ("object".equals(((ApiDataFieldLocaleMetadataDTO)reqApiDataFieldLocaleMetadataDTOS.get(i)).getData_type())) {
                    MetadataTranslator.translateRecursively(field, requestParams.getField(), getLang, productNameGetter);
                    continue;
                }
                if (productNameGetter == null) continue;
                ((ApiDataFieldLocaleMetadataDTO)reqApiDataFieldLocaleMetadataDTOS.get(i)).setPrecision(MetadataTranslator.getFieldPrecisionByProductName(requestParams, productNameGetter));
            }
        }
        ApiDataFieldLocaleMetadataDTO resApiDataFieldLocaleMetadataDTO = localeResponseDTO.getResponse().getData();
        ApiDataFieldMetadataDTO resFieldMetadata = responseDTO.getResponse().getData();
        if (resApiDataFieldLocaleMetadataDTO != null) {
            resApiDataFieldLocaleMetadataDTO.setDescription(MetadataTranslator.getTargetLang(getLang, resFieldMetadata, resFieldMetadata.getClass(), DESCRIPTION_FILED));
            resApiDataFieldLocaleMetadataDTO.setRemark(MetadataTranslator.getTargetLang(getLang, resFieldMetadata, resFieldMetadata.getClass(), REMARK_FILED));
            List responseField = resApiDataFieldLocaleMetadataDTO.getField();
            if (!CollectionUtils.isEmpty((Collection)responseField)) {
                for (int j = 0; j < responseField.size(); ++j) {
                    ((ApiDataFieldLocaleMetadataDTO)responseField.get(j)).setDescription(MetadataTranslator.getTargetLang(getLang, resFieldMetadata.getField().get(j), ((ApiDataFieldMetadataDTO)resFieldMetadata.getField().get(j)).getClass(), DESCRIPTION_FILED));
                    ((ApiDataFieldLocaleMetadataDTO)responseField.get(j)).setRemark(MetadataTranslator.getTargetLang(getLang, resFieldMetadata.getField().get(j), ((ApiDataFieldMetadataDTO)resFieldMetadata.getField().get(j)).getClass(), REMARK_FILED));
                    if ("object".equals(((ApiDataFieldLocaleMetadataDTO)responseField.get(j)).getData_type())) {
                        MetadataTranslator.translateRecursively(responseField, resFieldMetadata.getField(), getLang, productNameGetter);
                        continue;
                    }
                    if (productNameGetter == null) continue;
                    ((ApiDataFieldLocaleMetadataDTO)responseField.get(j)).setPrecision(MetadataTranslator.getFieldPrecisionByProductName((ApiDataFieldMetadataDTO)resFieldMetadata.getField().get(j), productNameGetter));
                }
            } else if (productNameGetter != null) {
                resApiDataFieldLocaleMetadataDTO.setPrecision(MetadataTranslator.getFieldPrecisionByProductName(resFieldMetadata, productNameGetter));
            }
        }
    }

    public static void translateRecursively(List<ApiDataFieldLocaleMetadataDTO> target, List<ApiDataFieldMetadataDTO> source, String getLang, ProductNameGetter productNameGetter) {
        if (null == target || null == source) {
            return;
        }
        for (int i = 0; i < target.size(); ++i) {
            target.get(i).setDescription(MetadataTranslator.getTargetLang(getLang, source.get(i), source.get(i).getClass(), DESCRIPTION_FILED));
            target.get(i).setRemark(MetadataTranslator.getTargetLang(getLang, source.get(i), source.get(i).getClass(), REMARK_FILED));
            if ("object".equals(target.get(i).getData_type())) {
                MetadataTranslator.translateRecursively(target.get(i).getField(), source.get(i).getField(), getLang, productNameGetter);
                continue;
            }
            if (productNameGetter == null) continue;
            target.get(i).setPrecision(MetadataTranslator.getFieldPrecisionByProductName(source.get(i), productNameGetter));
        }
    }

    public static String getFieldPrecisionByProductName(ApiDataFieldMetadataDTO source, ProductNameGetter productNameGetter) {
        FieldDataPrecision data_precision = source.getData_precision();
        List prodTypeList = null;
        if (data_precision != null && !CollectionUtils.isEmpty((Collection)(prodTypeList = data_precision.getProd_type()))) {
            if (null == productNameGetter) {
                return null;
            }
            String productName = productNameGetter.getProductName();
            if (StringUtils.isBlank((CharSequence)productName)) {
                return null;
            }
            Optional<ProdType> result = prodTypeList.stream().filter(e -> productName.equals(e.getProd_name())).findAny();
            if (result.isPresent()) {
                return result.get().getPrecision();
            }
        }
        return null;
    }

    private static String getTargetLang(String getLang, Object langTarget, Class langTargetClazz, String fieldCamel) {
        if (langTarget == null) {
            return "";
        }
        String getMethodStr = "get" + fieldCamel;
        try {
            Method langMethod = MultiLanguageDTO.class.getMethod(getLang, new Class[0]);
            Method targetMethod = langTargetClazz.getMethod(getMethodStr, new Class[0]);
            MultiLanguageDTO languageDTO = (MultiLanguageDTO)targetMethod.invoke(langTarget, new Object[0]);
            if (languageDTO == null) {
                return "";
            }
            String result = (String)langMethod.invoke((Object)languageDTO, new Object[0]);
            if (ObjectUtils.isEmpty((Object)result) && "getEn".equals(getLang)) {
                return MetadataTranslator.getTargetEnUSLang(langTarget, targetMethod);
            }
            return result;
        }
        catch (Exception e) {
            log.warn("error parse locale:{}", (Object)e.getMessage());
            return "";
        }
    }

    private static String getTargetEnUSLang(Object langTarget, Method targetMethod) {
        try {
            Method langMethod = MultiLanguageDTO.class.getMethod("getEn_US", new Class[0]);
            MultiLanguageDTO languageDTO = (MultiLanguageDTO)targetMethod.invoke(langTarget, new Object[0]);
            if (languageDTO == null) {
                return "";
            }
            String result = (String)langMethod.invoke((Object)languageDTO, new Object[0]);
            return result;
        }
        catch (Exception e) {
            log.warn("error parse locale:{}", (Throwable)e);
            return "";
        }
    }
}

