package com.digiwin.athena.kmservice.action.metadata;

import com.digiwin.athena.kmservice.common.Neo4jConstants;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.ESPActionExecutionDTO;
import org.springframework.stereotype.Component;

import java.util.Map;
@Component
public class EspActionHandlerImpl implements ActionHandler<Map<String, Object>> {
//    @Autowired
//    private ProductNameResolver productNameResolver;

    @Override
    public ActionDefinitionDTO processMetadata(Map<String, Object> actionMatched) {
        ActionDefinitionDTO espDefinitionDTO = new EspActionMetadataGenerator().Generate(actionMatched);
        return espDefinitionDTO;
    }

    @Override
    public ActionExecutionDTO processExecution(Map<String, Object> actionMatched) throws Exception{
        ESPActionExecutionDTO executionDTO = new ESPActionExecutionDTO();
        executionDTO.setServiceName(actionMatched.get(Neo4jConstants.PROPERTY_ESP_ACTION_SERVICE_NAME).toString());
        executionDTO.setUrl(actionMatched.get(Neo4jConstants.PROPERTY_ESP_ACTION_URL).toString());
        executionDTO.setActionId(actionMatched.get(Neo4jConstants.PROPERTY_ACTION_ID).toString());
        executionDTO.setType(ActionTypeEnum.ESP);
        //不在此处调用此接口，因为可能这个action不符合条件会被remove，等最后action确认时，再去查询productName
//        executionDTO.setProductName(this.productNameResolver.getProductName(executionDTO.getServiceName(),
//                actionMatched.get(ActionCons.TENANT_ID).toString()));
        return executionDTO;
    }

    @Override
    public String getActionLabel() {
        return Neo4jConstants.LABEL_ESP_ACTION;
    }
}
