package com.digiwin.athena.kmservice.action.metadata;

import com.digiwin.athena.kmservice.common.Neo4jConstants;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.FormulaActionDefinitionDTO;

import java.util.Map;

/**
 * @title: FormulacActionMetadataGenerator
 * @author: linc
 * @date 2024/3/1 14:33
 * @version: 1.0
 */
public class FormulacActionMetadataGenerator extends ActionMetadataGeneratorBase {
    @Override
    protected ActionDefinitionDTO CreateInstance(Map<String, Object> actionQueryResult) {
        FormulaActionDefinitionDTO metadataDTO = new FormulaActionDefinitionDTO();
        metadataDTO.setExpression(actionQueryResult.get(Neo4jConstants.PROPERTY_FORMULA_ACTION_EXPRESSION).toString());
        metadataDTO.setTarget(actionQueryResult.get(Neo4jConstants.PROPERTY_FORMULA_ACTION_TARGET).toString());
        metadataDTO.setType(ActionTypeEnum.FORMULAC);

        return metadataDTO;
    }

}
