package com.digiwin.athena.kmservice.cache;

import java.lang.annotation.*;

@Target({ ElementType.PARAMETER, ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Cache {

    /**
     * mvel2表达式，格式如 'knowledgegraph:'+ctx.tenantId+':'+ctx.locale+':'+ctx.userId+':'+'service.method'+p1+p2
     * 其中ctx是上下文信息，携带了tenantId、userid、locale等{tenantName=pass区测试租户(E10_6.0), tenantSid=380745286255168, tenantId=E10ATHENApass, userSid=381050902839872, userName=业务员1, userId=E10PASS14}
     * p1、p2是参数的名字，也可以使用参数对象的数据，如p1是个对象包含属性name则可以使用p1.name
     */
    String key();
    /**
     * 过期时间，单位秒， 默认2小时
     */
    long ttlSecs() default 7200L;


}
