package com.digiwin.athena.kmservice.configuration;

import com.alibaba.csp.sentinel.annotation.aspectj.SentinelResourceAspect;
import com.alibaba.csp.sentinel.slots.block.RuleConstant;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

@Configuration
public class ServiceConfiguration implements InitializingBean {

    @Autowired
    SentinelRuleProp sentinelRuleProp;


    @Bean
    public ObjectMapper myObjectMapper() {
        ObjectMapper mapper = Jackson2ObjectMapperBuilder.json()
                .simpleDateFormat("yyyy-MM-dd HH:mm:ss")
                .serializationInclusion(JsonInclude.Include.NON_NULL)
                .build();
        return mapper;
    }

    @Bean("baseExecutor")
    @Primary
    public ThreadPoolTaskExecutor baseExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        // 核心线程数 当前机器核心数
        executor.setCorePoolSize(16);
        // 最大线程数=核心线程数*2
        executor.setMaxPoolSize(200);
        // 队列长度
        executor.setQueueCapacity(1000);
        // 允许线程空闲时间
        executor.setKeepAliveSeconds(30);
        // 线程池名称前缀
        executor.setThreadNamePrefix("baseExecutor_");
        // 自定义拒绝策略
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }


//    @Bean
//    public Executor taskExecutor() {
//        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
//        executor.setThreadGroupName("taskExecutors");
//        executor.setThreadNamePrefix("taskExecutors");
//        executor.setCorePoolSize(Runtime.getRuntime().availableProcessors()*2);
//        executor.setMaxPoolSize(300);
//        executor.setQueueCapacity(0);
//        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
//        executor.initialize();
//        return executor;
//    }


    @Bean
    public SentinelResourceAspect sentinelResourceAspect() {
        return new SentinelResourceAspect();
    }


    public void initSentinelRules(){
        List<FlowRule> rules = new ArrayList<>();
        sentinelRuleProp.getSources().forEach((k,v)->{
            FlowRule rule = new FlowRule();
            rule.setResource(k);
            rule.setGrade(RuleConstant.FLOW_GRADE_QPS);
            rule.setCount(v);
            rules.add(rule);
        });
        FlowRuleManager.loadRules(rules);
    }


    @Override
    public void afterPropertiesSet() throws Exception {

        initSentinelRules();
    }
}
