/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.service;

import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.digiwin.athena.domain.core.Project;
import com.digiwin.athena.kg.dto.DependencyAndMapsDTO;
import com.digiwin.athena.kmservice.cache.Cache;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class TestServiceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestServiceService.class);
    @Autowired(required=false)
    private ActionRepository actionRepository;

    @Async
    public String test01(Integer i) {
        System.out.println(Thread.currentThread().getName() + " test01..." + i);
        return "ok" + i;
    }

    @Cache(key="ctx.tenantId+':projects:'+code+tenantId+ctx.locale")
    public List<Project> projects(String code, String tenantId) {
        System.out.println("projects.......");
        ArrayList<Project> projects = new ArrayList<Project>();
        for (int i = 0; i < 10; ++i) {
            Project p = new Project();
            p.setCode("code" + i);
            p.setName("\u9879\u76ee" + i);
            projects.add(p);
        }
        return projects;
    }

    @Lang
    public Project projects1(String code) {
        Project p = new Project();
        p.setCode("code1");
        p.setName("\u9879\u76ee1");
        p.setLang(new HashMap());
        HashMap<String, String> nameLang = new HashMap<String, String>();
        nameLang.put("zh_CN", "\u4f9b\u5e94\u5546\u56de\u590dcn");
        nameLang.put("zh_TW", "\u4f9b\u61c9\u5546\u56de\u8986tw");
        nameLang.put("en_US", "supplier replay");
        p.getLang().put("name", nameLang);
        return p;
    }

    @Cache(key="'knowledgegraph:SYSTEM:'+ctx.tenantId+':'+ctx.locale+':'+ctx.userId+':'+'projects2:'+code+taskCodes")
    @Lang
    public List<Project> projects2(String code, List<String> taskCodes) {
        System.out.println("projects2.......");
        ArrayList<Project> projects = new ArrayList<Project>();
        for (int i = 0; i < 10; ++i) {
            Project p = new Project();
            p.setCode("code" + i);
            p.setName("\u9879\u76ee" + i);
            p.setLang(new HashMap());
            HashMap<String, String> nameLang = new HashMap<String, String>();
            nameLang.put("zh_CN", "\u4f9b\u5e94\u5546\u56de\u590d");
            nameLang.put("zh_TW", "\u4f9b\u61c9\u5546\u56de\u8986");
            nameLang.put("en_US", "supplier replay");
            p.getLang().put("name", nameLang);
            projects.add(p);
        }
        return projects;
    }

    @SentinelResource(value="test", blockHandler="handleException", blockHandlerClass={ExceptionUtil.class})
    public void test() {
        System.out.println(Thread.currentThread().getName() + " Test " + System.currentTimeMillis());
    }

    @SentinelResource(value="hello", blockHandler="exceptionHandler", fallback="helloFallback")
    public String hello(long s) {
        return String.format("Hello at %d", s);
    }

    public String helloFallback(long s) {
        return String.format("Halooooo %d", s);
    }

    public String exceptionHandler(long s, BlockException ex) {
        log.error(ex.getMessage(), (Throwable)ex);
        return "Oops, error occurred at " + s;
    }

    public Object getDataInfo(String actionId, String tenantId, String tenantVersion) {
        List<DependencyAndMapsDTO> dependencyAndMapsDTOS = this.actionRepository.queryDependencyAndMaps(actionId, tenantId, tenantVersion);
        HashMap<String, List<DependencyAndMapsDTO>> dataInfo = new HashMap<String, List<DependencyAndMapsDTO>>();
        dataInfo.put("dependencyAndMapsDTOS", dependencyAndMapsDTOS);
        return dataInfo;
    }
}

