package com.digiwin.athena.kmservice.neo4j;

import lombok.Getter;
import lombok.Setter;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.transaction.Neo4jTransactionManager;

import java.util.List;
import java.util.concurrent.TimeUnit;

@Configuration
@ConditionalOnProperty(value = "spring.data.neo4j.domain1.enable", havingValue = "true")
@EnableNeo4jRepositories(
        sessionFactoryRef = Neo4j1Config.SESSION_FACTORY,
        transactionManagerRef = Neo4j1Config.TRANSACTION_MANAGER)
@ConfigurationProperties(prefix = "spring.data.neo4j.domain1")
@Setter
@Getter
public class Neo4j1Config {

    {
        System.out.println("Neo4j1Config........");
    }

    public static final String SESSION_FACTORY = "sessionFactoryForDomain1";
    public static final String TRANSACTION_MANAGER = "transactionManagerForDomain1";

    private String uri;

    private String username;

    private String password;

    private Boolean enable;

    @Bean("neo4jDriverDomain1")
    public org.neo4j.driver.v1.Driver neo4jDriverDomain1() {
        System.out.println("neo4jDriverDomain1... url=" + this.uri + ",username=" + this.username + ",password=" + this.password);

        Config config = Config.build()
                .withConnectionTimeout(10, TimeUnit.SECONDS)
                .withConnectionLivenessCheckTimeout(2, TimeUnit.MINUTES)
                .withMaxConnectionLifetime(4, TimeUnit.MINUTES)
                .withMaxConnectionPoolSize(20)
                .withConnectionAcquisitionTimeout(1, TimeUnit.MINUTES)
                .toConfig();
        return GraphDatabase.driver(this.uri, AuthTokens.basic(this.username, this.password), config);
    }

    @Bean("ogmDriverDomain1")
    public Driver ogmDriverDomain1() {
        Driver ogmDriver = new BoltDriver(neo4jDriverDomain1());
        return ogmDriver;
    }

    @Bean(name = SESSION_FACTORY)
    public SessionFactory sessionFactory(ApplicationContext applicationContext) {
        String[] packages = getPackagesToScan(applicationContext);
        return new SessionFactory(ogmDriverDomain1(), packages);
    }

    @Bean(name = TRANSACTION_MANAGER) // <3>
    public Neo4jTransactionManager neo4jTransactionManager(ApplicationContext applicationContext) {
        System.out.println("==========neo4jTransactionManager1==========");
        return new Neo4jTransactionManager(sessionFactory(applicationContext));
    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
        List<String> packages = EntityScanPackages.get(applicationContext)
                .getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has(applicationContext)) {
            packages = AutoConfigurationPackages.get(applicationContext);
        }
        return org.springframework.util.StringUtils.toStringArray(packages);
    }
}
