/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.analysis;

import com.digiwin.athena.kmservice.analysis.AnalysisTool;
import com.digiwin.athena.kmservice.analysis.UriAnalysisBean;
import com.digiwin.athena.kmservice.analysis.UriAnalysisFilter;
import com.digiwin.athena.kmservice.configuration.KmMongoConfiguration;
import com.digiwin.athena.kmservice.support.KmRestTemplate;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnalysisComponent {
    @Autowired
    KmRestTemplate kmRestTemplate;
    @Autowired
    UriAnalysisFilter uriAnalysisFilter;
    @Autowired
    MongoClient mongoClient;

    public UriAnalysisBean commonRestTemplateStatics() {
        PoolingHttpClientConnectionManager connectionManager = this.kmRestTemplate.getConnectionManager();
        UriAnalysisBean uriAnalysisBean = new UriAnalysisBean();
        PoolStats total = connectionManager.getTotalStats();
        uriAnalysisBean.setMax(total.getMax());
        uriAnalysisBean.setLeased(total.getLeased());
        uriAnalysisBean.setPending(total.getPending());
        uriAnalysisBean.setAvailable(total.getAvailable());
        HashMap<String, PoolStats> statsMap = new HashMap<String, PoolStats>();
        for (HttpRoute route : connectionManager.getRoutes()) {
            PoolStats routeStats = connectionManager.getStats(route);
            statsMap.put(route.getTargetHost().getHostName(), routeStats);
        }
        uriAnalysisBean.setExt(statsMap);
        return uriAnalysisBean;
    }

    public Map<String, Object> mongoStatics() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        MongoClientOptions options = this.mongoClient.getMongoClientOptions();
        result.put("options", options.toString());
        result.put("queued", KmMongoConfiguration.waitQueue.get());
        result.put("pooled", KmMongoConfiguration.connect.get());
        result.put("leased", KmMongoConfiguration.connectCheck.get());
        return result;
    }

    public Map<String, Object> allAnalysisInfo() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, UriAnalysisBean> uriInfo = this.uriAnalysisFilter.uriAnalysisBeanMap();
        Map<String, Object> jvmInfo = AnalysisTool.jvmInfo();
        result.put("requestInfo", uriInfo);
        result.put("jvmInfo", jvmInfo);
        result.put("commonRestTemplate", this.commonRestTemplateStatics());
        result.put("mongo", this.mongoStatics());
        return result;
    }
}

