/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.service;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.povo.CleanCacheReq;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class KmGeneralService {
    private static final Logger log = LoggerFactory.getLogger(KmGeneralService.class);
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    @Qualifier(value="commonRestTemplate")
    private RestTemplate restTemplate;

    public Integer cleanCache(CleanCacheReq req) {
        Integer count = 0;
        if (null == req.getCleanType() || 0 == req.getCleanType()) {
            count = this.deleteKeys("knowledgegraph:SYSTEM:*");
        }
        if (1 == req.getCleanType() && null != req.getTenants()) {
            for (String tenantId : req.getTenants()) {
                count = count + this.deleteKeys("knowledgegraph:SYSTEM:" + tenantId + ":*");
            }
        }
        if (2 == req.getCleanType() && null != req.getPatterns()) {
            for (String pattern : req.getPatterns()) {
                count = count + this.deleteKeys(pattern);
            }
        }
        return count;
    }

    public Long deleteKeys(List<String> keys) throws Exception {
        Long delete = this.redisTemplate.delete(keys);
        return delete;
    }

    private Integer deleteKeys(String pattern) {
        Set keys = this.redisTemplate.keys((Object)pattern);
        this.redisTemplate.delete((Collection)keys);
        return keys.size();
    }

    public Long blurScanDelete(String matchKey, int count) {
        return (Long)this.redisTemplate.execute(connection -> {
            long keyCount = 0L;
            try (Cursor cursor = connection.scan(new ScanOptions.ScanOptionsBuilder().count((long)count).match(matchKey).build());){
                long cursorId = cursor.getCursorId();
                HashSet<String> keys = new HashSet<String>();
                while (cursor.hasNext()) {
                    keys.add(new String((byte[])cursor.next()));
                    if (cursorId != cursor.getCursorId()) {
                        keyCount += (long)keys.size();
                        this.redisTemplate.delete(keys);
                        keys = new HashSet();
                    }
                    cursorId = cursor.getCursorId();
                }
                if (cursor.getCursorId() == 0L || CollectionUtils.isNotEmpty(keys)) {
                    keyCount += (long)keys.size();
                    this.redisTemplate.delete(keys);
                }
            }
            catch (Exception e) {
                log.error("blurScanDelete failed,{}", (Object)e.toString());
            }
            return keyCount;
        });
    }

    @Lang
    public <T> List<T> handleLang(List<T> list) {
        return list;
    }

    @Lang
    public <T> T handleLang(T t) {
        return t;
    }
}

