/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class EocUtils {
    private static final Logger log = LoggerFactory.getLogger(EocUtils.class);
    @Value(value="${eocUrl:null}")
    private String eocUrl;
    @Value(value="${iamApToken:null}")
    private String iamApToken;
    @Autowired
    @Qualifier(value="commonRestTemplate")
    RestTemplate restTemplate;

    public JSONObject getOperationUnitTree(String token) throws DWBusinessException {
        String url = this.eocUrl + "/api/eoc/v2/org/tree";
        return this.requestEoc(token, url);
    }

    public String getOperationUnitPath(String token, String id) throws DWBusinessException {
        String url = this.eocUrl + "/api/eoc/v2/org/tree/node?type=1&id=" + id;
        JSONObject data = this.requestEoc(token, url);
        return data != null ? data.getString("uri") : null;
    }

    public JSONObject requestEoc(String token, String url) throws DWBusinessException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.iamApToken);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity resEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, JSONObject.class, new Object[0]);
        JSONObject body = (JSONObject)resEntity.getBody();
        if (body == null) {
            log.error("\u67e5\u8be2\u79df\u6237\u7ec4\u7ec7\u6811\u5f02\u5e38\uff0c\u8fd4\u56debody\u4e3a\u7a7a");
            throw new DWBusinessException("\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5f02\u5e38");
        }
        if (MapUtils.getInteger((Map)body, (Object)"code") != 200) {
            throw new DWBusinessException(MapUtils.getString((Map)body, (Object)"message"));
        }
        return body.getJSONObject("data");
    }

    public List<String> getOperationUnitIdList(String token) throws DWBusinessException {
        JSONObject operationUnitTree = this.getOperationUnitTree(token);
        LinkedList<String> idList = new LinkedList<String>();
        this.extractIds(operationUnitTree, idList);
        return idList;
    }

    private void extractIds(JSONObject node, List<String> idList) {
        JSONArray children;
        if (node == null) {
            return;
        }
        String id = node.getString("id");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            idList.add(id);
        }
        if (!CollectionUtils.isEmpty((Collection)(children = node.getJSONArray("children")))) {
            for (int i = 0; i < children.size(); ++i) {
                this.extractIds(children.getJSONObject(i), idList);
            }
        }
    }
}

