package com.digiwin.athena.kmservice.action.metadata;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;

import java.util.Map;
import java.util.Objects;

/**
 * @title: BmdGeneralActionMetadataGenerator
 * @author: linc
 * @date 2023/11/22 14:59
 * @version: 1.0
 */
public class BizParamActionMetadataGenerator extends ActionMetadataGeneratorBase {

    @Override
    protected ActionDefinitionDTO CreateInstance(Map<String, Object> actionQueryResult) {
        ActionDefinitionDTO metadataDTO = new ActionDefinitionDTO();
        metadataDTO.setType(ActionTypeEnum.BIZ_PARAM);
        if (Objects.nonNull(actionQueryResult.get("bizParamMeta"))) {
            metadataDTO.setBizParamMeta(JSON.parseObject(actionQueryResult.get("bizParamMeta").toString()));
        }
        return metadataDTO;
    }
}