package com.digiwin.athena.kmservice.cache.old;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.*;
import java.util.concurrent.TimeUnit;

@Aspect
@Component("oldCacheAspect")
@Slf4j
public class CacheAspect {

    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private RedisConf redisConf;


    @Around("@annotation(com.digiwin.athena.kmservice.cache.old.Cache)")
    public Object cache(ProceedingJoinPoint jp) throws Throwable {
        if (!redisConf.getUse()) { //不使用缓存
            return jp.proceed();
        }
        final Signature sig = jp.getSignature();
        if (!(sig instanceof MethodSignature)) {
            throw new IllegalArgumentException("该注解只能放在方法上");
        }
        final MethodSignature msig = (MethodSignature) sig;

        final Method method = msig.getMethod();
        final Cache annotation = method.getAnnotation(Cache.class);
        final Class<?> returnType = method.getReturnType();
        final RedisDataType redisDataType = annotation.dataType();
        boolean language = annotation.language();
        boolean tenant = annotation.tenant();
        String key = this.generateKey(method, jp.getArgs(), language, tenant);
        Object result = null;
        Boolean hasKey = false;
        Boolean proceedThrowError = false;
        final StopWatch clock = new StopWatch();
        try {
            clock.start();
            if (RedisDataType.STRING.equals(redisDataType)) {
//                this.log.info("get data from cache with key({})", key);
                hasKey = this.redisTemplate.hasKey(key);
                result = this.redisTemplate.opsForValue().get(key);
                this.log.info("hasKey({}):{},resultIsEmpty:{}", key, hasKey, ObjectUtils.isEmpty(result));
                if ((!hasKey && ObjectUtils.isEmpty(result))
                        || (hasKey && ObjectUtils.isEmpty(result) && !annotation.loadEmpty())) {  //如果不存在key
                    // ，并且为空值，则调用具体方法,或者存在key，但值为空，但又不会存空值（loadEmpty=false）
                    this.log.info("get data from cache with key({}) is null, execute method", key);
                    try {
                        result = jp.proceed();
                    } catch (Throwable throwable) {
                        proceedThrowError = true;
                        throw  throwable;
//                        throw new ProceedException(throwable);
                    }
                    if (!ObjectUtils.isEmpty(result) || annotation.loadEmpty()) {  //结果不为空 或者 结果为空但需要设置空值时
                        if (annotation.ttlSecs() == 0) {
                            this.redisTemplate.opsForValue().set(key, result);
                        } else {
                            this.redisTemplate.opsForValue().set(key, result, annotation.ttlSecs(), TimeUnit.SECONDS);
                        }
                    }
                }
            }
            //TODO redis其他数据类型比如map等有需要时再实现

        } catch (Throwable throwable) {
            if (proceedThrowError) { //执行真正方法出现异常，抛出
                throw throwable;
            } else { // 执行redis出现异常，则直接执行方法
                try {
                    log.error("cache error:{}, execute method", throwable.getMessage());
                    result = jp.proceed();
                } catch (Throwable t1) {
                    throw t1;
                }
            }
        }
        clock.stop();
        //   this.log.info("call method:{} hasRedisKey({}):{} , cost time {}ms", method.getName(), key, hasKey, clock
        //   .getTotalTimeMillis());
        return result;

    }


    private Object castedValue(Object value) throws Exception {
        String result = this.toString(value);
        String[] split = StringUtils.split(result, CacheCons.CLASS_SPLIT);
        if (split.length == 3) {
            return JSON.parseArray(split[2], Class.forName(split[1]));
        } else if (split.length == 2) {
            return JSON.parseObject(split[1], Class.forName(split[0]));
        } else {
            return value;
        }
    }

    private String valueWithClazz(Object result, Method method) {
        Type genericReturnType = method.getGenericReturnType();
        if (null == genericReturnType) {
            return JSON.toJSONString(result);
        }
        if (genericReturnType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType) genericReturnType;
            // 得到泛型里的class类型对象
            Type actualTypeArgument1 = pt.getActualTypeArguments()[0];
            return result.getClass().getName() + CacheCons.CLASS_SPLIT + actualTypeArgument1.getTypeName() + CacheCons.CLASS_SPLIT + JSON.toJSONString(result);
//            Class<?> actualTypeArgument = (Class<?>)pt.getActualTypeArguments()[0];
//            return result.getClass().getName() + CacheCons.CLASS_SPLIT + actualTypeArgument.getName() + CacheCons
//            .CLASS_SPLIT+ JSON.toJSONString(result);
        } else {
            return result.getClass().getName() + CacheCons.CLASS_SPLIT + JSON.toJSONString(result);
        }

    }

    private String valueWithClazz(Object result) {
        return result.getClass().getName() + CacheCons.CLASS_SPLIT + JSON.toJSONString(result);
    }

    /**
     * 生成redis的key
     *
     * @param method
     * @param language
     * @param tenant
     * @return
     */
    private String generateKey(Method method, Object[] args, boolean language, boolean tenant) {
        final Cache annotation = method.getAnnotation(Cache.class);
        String redisKey = annotation.key();
        if (StringUtils.isEmpty(redisKey)) { //如果没有设置key，则用方法名成表示key
            redisKey = method.getName();
        }
        StringBuilder sb = new StringBuilder(annotation.namespace());
        // 应用
        boolean application = annotation.application();
        String applicationCode = "SYSTEM";
        if (application) {
            ServletRequestAttributes requestAttributes =
                    (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
            if (requestAttributes != null) {
                HttpServletRequest request = requestAttributes.getRequest();
                applicationCode = ObjectUtils.isEmpty(request.getHeader("applicationCode")) ? "SYSTEM" : request.getHeader("applicationCode");
            }
        }
        sb.append(CacheCons.NAMESPACE_SPLIT).append(applicationCode);
        // 租户
        String tenantId = "SYSTEM";
        if (tenant) {
            ServletRequestAttributes requestAttributes =
                    (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
            if (requestAttributes != null) {
                HttpServletRequest request = requestAttributes.getRequest();
                tenantId = ObjectUtils.isEmpty(request.getAttribute("tenantId")) ?
                        "SYSTEM" : request.getAttribute("tenantId").toString();
            }
        }
        sb.append(CacheCons.NAMESPACE_SPLIT).append(tenantId);
        String locale = "zh_CN";
        if (language) {
            ServletRequestAttributes requestAttributes =
                    (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
            if (requestAttributes != null) {
                HttpServletRequest request = requestAttributes.getRequest();
                locale = ObjectUtils.isEmpty(request.getHeader("locale")) ? "zh_CN" : request.getHeader("locale");
            }
        }
        sb.append(CacheCons.NAMESPACE_SPLIT).append(locale);
        sb.append(CacheCons.NAMESPACE_SPLIT);
        if (annotation.useParamIndex()) { //使用ParamIndex来构造Key
            sb.append(redisKey);
            int parameterCount = method.getParameterCount();
            if (parameterCount == 0) {
                return sb.toString();
            } else if (parameterCount == 1) {
                return sb.append(CacheCons.KEY_SPLIT).append(args[0]).toString();
            } else {
                boolean hasKeyParam = false;
                Parameter[] parameters = method.getParameters();
                StringBuilder noKeyParam = new StringBuilder();
                SortedMap<Integer, List<Integer>> sortedMap = new TreeMap<>();
                List<Integer> orderList = null;
                //如果方法字段有KeyParam注解，则取KeyParam注解的字段，并按value值排序构造redis的key, 否则默认按方法中所有参数的顺序构造reids的key
                for (int i = 0; i < parameters.length; i++) {
                    ParamIndex annotationKeyParam = parameters[i].getAnnotation(ParamIndex.class);
                    if (annotationKeyParam != null) {
                        hasKeyParam = true;
                        if (sortedMap.containsKey(annotationKeyParam.order())) {
                            sortedMap.get(annotationKeyParam.order()).add(annotationKeyParam.value());
                        } else {
                            orderList = new ArrayList<>();
                            orderList.add(annotationKeyParam.value());
                            sortedMap.put(annotationKeyParam.order(), orderList);
                        }
                    }
                    if (!hasKeyParam) {
                        noKeyParam.append(CacheCons.KEY_SPLIT).append(args[i]);
                    }
                }
                if (hasKeyParam) {
                    StringBuffer keyParam = new StringBuffer();
                    for (Map.Entry<Integer, List<Integer>> temp : sortedMap.entrySet()) {
                        temp.getValue().forEach(e -> {
                            keyParam.append(CacheCons.KEY_SPLIT).append(args[e]);
                        });
                    }
                    return sb.append(keyParam).toString();
                } else {
                    return sb.append(noKeyParam).toString();
                }
            }
        } else { // 用Key上的占位符$来构造key
            Class<?>[] parameterTypes = method.getParameterTypes();
            String[] split = StringUtils.split(redisKey, CacheCons.VALUE_SPLIT);
            StringBuilder toReplaceKey = new StringBuilder(split[0]);
            if (split.length > 1) { //有占位符时,替换占位符
                for (int i = 1; i < split.length; i++) {
//                    toReplaceKey = toReplaceKey.append(CacheCons.KEY_SPLIT).append(args[Integer.parseInt(split[i])]);
                    toReplaceKey.append(CacheCons.KEY_SPLIT).append(this.toString(args[Integer.parseInt(split[i])], parameterTypes[Integer.parseInt(split[i])]));
                }
            }
            return sb.append(toReplaceKey).toString();
        }
    }

    /**
     * 获取redis map类型的field
     *
     * @return
     */
    private String getField() {

        return null;
    }

    /**
     * 获取请求参数
     *
     * @param jp 切入点
     * @return
     */
    private String getRequestParam(ProceedingJoinPoint jp) {
        try {
            final List<String> paramList = new ArrayList<>();
            final Object[] args = jp.getArgs();
            for (final Object arg : args) {
                if (arg instanceof HttpServletRequest) {
                    continue;
                }
                if (arg instanceof HttpServletResponse) {
                    continue;
                }
                final String paramStr = this.toString(arg);
                if (paramStr != null) {
                    paramList.add(paramStr);
                }
            }
            return paramList.toString();
        } catch (final Exception e) {
            this.log.error("获取请求参数异常", e);
        }
        return "";
    }

    private String toString(Object arg) {
        if (arg instanceof String) {
            return String.valueOf(arg);
        }
        return JSON.toJSONString(arg);
    }

    private String toString(Object arg, Class type) {
        if(isPrimitive(type)){
            return String.valueOf(arg);
        }else{
            return JSON.toJSONString(arg);
        }
    }

    private static boolean isPrimitive(Class<?> c) {
        if (c != null) {

            if (c.isPrimitive() || c.equals(String.class) || Number.class.isAssignableFrom(c) || Boolean.class.equals(c)
                    || Character.class.isAssignableFrom(c) || Date.class.equals(c) || java.sql.Date.class.equals(c)) {
                return true;
            }

        }

        return false;
    }

    private static boolean isWrapClass(Class clz) {
        try {
            return ((Class) clz.getField("TYPE").get(null)).isPrimitive();
        } catch (Exception e) {
            return false;
        }
    }


}
