package com.digiwin.athena.kmservice.service.impl;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kmservice.service.KmApplicationService;
import com.digiwin.athena.kmservice.service.KmDBService;
import com.digiwin.athena.kmservice.utils.MergeUtil;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;


@Service
public class DbApplicationServiceImpl extends KmDBService implements KmApplicationService {

    @Override
    public Application applicationByCodeAndVersion(String code, String version) throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantId();
        List<Application> applications = this.systemTemplate().find(Query.query(Criteria.where("tenantId").in(tenantId, "SYSTEM", null).and("code").is(code).and("version").is(version)), Application.class);
        applications = MergeUtil.excludeSameCode(applications, Application.class, null);
        return CollectionUtils.isNotEmpty(applications) ? applications.get(0) : null;


    }

    @Override
    public List<String> getCodeByTypeAndAppCodeAndVersion(String type, String appCode, String version) throws DWBusinessException {
        Query query = Query.query(Criteria.where("appCode").is(appCode).and("type").is(type).and("version").is(version));
        List<ApplicationRelation> relations = systemTemplate().find(query, ApplicationRelation.class);
        return relations.stream().map(ApplicationRelation::getCode).distinct().collect(Collectors.toList());
    }

    @Override
    public MongoTemplate systemTemplate() {
        return super.getMongoTemplateSys();
    }

    @Override
    public MongoTemplate tenantTemplate() {
        return super.getMongoTemplateTenant();
    }
}
