package org.neo4j.ogm.metadata;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.typeconversion.AttributeConverter;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-09-29 14:10
 **/
@Slf4j
public class AthenaAttributeConverter implements AttributeConverter<Object,String> {

    private boolean array;
    private Class<?> clazz;

    public AthenaAttributeConverter(boolean array,Class<?> value){
        this.array = array;
        this.clazz=value;
    }

    @Override
    public String toGraphProperty(Object value) {
        if(null!=value){
            return JSON.toJSONString(value);
        }
        return null;
    }

    @Override
    public Object toEntityAttribute(String value) {
        //log.info("AthenaAttributeConverter parse val:{}", value);
        //log.info("AthenaAttributeConverter parse val type:{}", clazz);
        if(StringUtils.isEmpty(value)){return null;}
        try{
            if(array){
                return JSON.parseArray(value,clazz);
            }
            return JSON.parseObject(value,clazz);
        }catch(Exception e){
            log.error("athena neo4j转换失败,value:{} 不能转换为:{}",value,clazz);
        }
        return null;
    }
}
