/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.neo4j;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.data.neo4j.transaction.Neo4jTransactionManager;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(value={"spring.data.neo4j.domain1.enable"}, havingValue="true")
@EnableNeo4jRepositories(sessionFactoryRef="sessionFactoryForDomain1", transactionManagerRef="transactionManagerForDomain1")
@ConfigurationProperties(prefix="spring.data.neo4j.domain1")
public class Neo4j1Config {
    public static final String SESSION_FACTORY = "sessionFactoryForDomain1";
    public static final String TRANSACTION_MANAGER = "transactionManagerForDomain1";
    private String uri;
    private String username;
    private String password;
    private Boolean enable;

    public Neo4j1Config() {
        System.out.println("Neo4j1Config........");
    }

    @Bean(value={"neo4jDriverDomain1"})
    public org.neo4j.driver.v1.Driver neo4jDriverDomain1() {
        System.out.println("neo4jDriverDomain1... url=" + this.uri + ",username=" + this.username + ",password=" + this.password);
        Config config = Config.build().withConnectionTimeout(10L, TimeUnit.SECONDS).withConnectionLivenessCheckTimeout(2L, TimeUnit.MINUTES).withMaxConnectionLifetime(4L, TimeUnit.MINUTES).withMaxConnectionPoolSize(20).withConnectionAcquisitionTimeout(1L, TimeUnit.MINUTES).toConfig();
        return GraphDatabase.driver((String)this.uri, (AuthToken)AuthTokens.basic((String)this.username, (String)this.password), (Config)config);
    }

    @Bean(value={"ogmDriverDomain1"})
    public Driver ogmDriverDomain1() {
        BoltDriver ogmDriver = new BoltDriver(this.neo4jDriverDomain1());
        return ogmDriver;
    }

    @Bean(name={"sessionFactoryForDomain1"})
    public SessionFactory sessionFactory(ApplicationContext applicationContext) {
        String[] packages = this.getPackagesToScan(applicationContext);
        return new SessionFactory(this.ogmDriverDomain1(), packages);
    }

    @Bean(name={"transactionManagerForDomain1"})
    public Neo4jTransactionManager neo4jTransactionManager(ApplicationContext applicationContext) {
        System.out.println("==========neo4jTransactionManager1==========");
        return new Neo4jTransactionManager(this.sessionFactory(applicationContext));
    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
        List packages = EntityScanPackages.get((BeanFactory)applicationContext).getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has((BeanFactory)applicationContext)) {
            packages = AutoConfigurationPackages.get((BeanFactory)applicationContext);
        }
        return StringUtils.toStringArray((Collection)packages);
    }

    @Generated
    public void setUri(String uri) {
        this.uri = uri;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    @Generated
    public String getUri() {
        return this.uri;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Boolean getEnable() {
        return this.enable;
    }
}

