/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.service;

import com.digiwin.athena.kmservice.constants.KnowledgeGraphDb;
import com.mongodb.MongoClient;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;

public abstract class KmDBService
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KmDBService.class);
    private MongoTemplate mongoTemplateSys;
    private MongoTemplate mongoTemplateTenant;
    @Autowired
    MongoClient mongo;
    @Autowired
    @Qualifier(value="mappingMongoConverterSystem")
    MappingMongoConverter mappingMongoConverterSystem;

    public abstract MongoTemplate systemTemplate();

    public abstract MongoTemplate tenantTemplate();

    public void afterPropertiesSet() {
        SimpleMongoDbFactory mongoDbFactorySys = new SimpleMongoDbFactory(this.mongo, KnowledgeGraphDb.SYSTEM.getValue());
        this.mongoTemplateSys = new MongoTemplate((MongoDbFactory)mongoDbFactorySys, (MongoConverter)this.mappingMongoConverterSystem);
        SimpleMongoDbFactory mongoDbFactoryTenant = new SimpleMongoDbFactory(this.mongo, KnowledgeGraphDb.TENANT.getValue());
        this.mongoTemplateTenant = new MongoTemplate((MongoDbFactory)mongoDbFactoryTenant, (MongoConverter)this.mappingMongoConverterSystem);
    }

    @Generated
    public KmDBService() {
    }

    @Generated
    public MongoTemplate getMongoTemplateSys() {
        return this.mongoTemplateSys;
    }

    @Generated
    public MongoTemplate getMongoTemplateTenant() {
        return this.mongoTemplateTenant;
    }

    @Generated
    public MongoClient getMongo() {
        return this.mongo;
    }

    @Generated
    public MappingMongoConverter getMappingMongoConverterSystem() {
        return this.mappingMongoConverterSystem;
    }

    @Generated
    public void setMongoTemplateSys(MongoTemplate mongoTemplateSys) {
        this.mongoTemplateSys = mongoTemplateSys;
    }

    @Generated
    public void setMongoTemplateTenant(MongoTemplate mongoTemplateTenant) {
        this.mongoTemplateTenant = mongoTemplateTenant;
    }

    @Generated
    public void setMongo(MongoClient mongo) {
        this.mongo = mongo;
    }

    @Generated
    public void setMappingMongoConverterSystem(MappingMongoConverter mappingMongoConverterSystem) {
        this.mappingMongoConverterSystem = mappingMongoConverterSystem;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KmDBService)) {
            return false;
        }
        KmDBService other = (KmDBService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MongoTemplate this$mongoTemplateSys = this.getMongoTemplateSys();
        MongoTemplate other$mongoTemplateSys = other.getMongoTemplateSys();
        if (this$mongoTemplateSys == null ? other$mongoTemplateSys != null : !this$mongoTemplateSys.equals(other$mongoTemplateSys)) {
            return false;
        }
        MongoTemplate this$mongoTemplateTenant = this.getMongoTemplateTenant();
        MongoTemplate other$mongoTemplateTenant = other.getMongoTemplateTenant();
        if (this$mongoTemplateTenant == null ? other$mongoTemplateTenant != null : !this$mongoTemplateTenant.equals(other$mongoTemplateTenant)) {
            return false;
        }
        MongoClient this$mongo = this.getMongo();
        MongoClient other$mongo = other.getMongo();
        if (this$mongo == null ? other$mongo != null : !this$mongo.equals(other$mongo)) {
            return false;
        }
        MappingMongoConverter this$mappingMongoConverterSystem = this.getMappingMongoConverterSystem();
        MappingMongoConverter other$mappingMongoConverterSystem = other.getMappingMongoConverterSystem();
        return !(this$mappingMongoConverterSystem == null ? other$mappingMongoConverterSystem != null : !this$mappingMongoConverterSystem.equals(other$mappingMongoConverterSystem));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KmDBService;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MongoTemplate $mongoTemplateSys = this.getMongoTemplateSys();
        result = result * 59 + ($mongoTemplateSys == null ? 43 : $mongoTemplateSys.hashCode());
        MongoTemplate $mongoTemplateTenant = this.getMongoTemplateTenant();
        result = result * 59 + ($mongoTemplateTenant == null ? 43 : $mongoTemplateTenant.hashCode());
        MongoClient $mongo = this.getMongo();
        result = result * 59 + ($mongo == null ? 43 : $mongo.hashCode());
        MappingMongoConverter $mappingMongoConverterSystem = this.getMappingMongoConverterSystem();
        result = result * 59 + ($mappingMongoConverterSystem == null ? 43 : $mappingMongoConverterSystem.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KmDBService(mongoTemplateSys=" + this.getMongoTemplateSys() + ", mongoTemplateTenant=" + this.getMongoTemplateTenant() + ", mongo=" + this.getMongo() + ", mappingMongoConverterSystem=" + this.getMappingMongoConverterSystem() + ")";
    }
}

