/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.extra.expression.ExpressionUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.support.DapContext;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServiceUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceUtils.class);
    private static ThreadLocal<DapContext> profileContext = new InheritableThreadLocal<DapContext>();
    private static ThreadLocal<String> eocHolder = new ThreadLocal();

    public static DapContext getContext() {
        DapContext context = profileContext.get();
        if (null == context) {
            context = new DapContext();
            Map profile = DWServiceContext.getContext().getProfile();
            Map header = DWServiceContext.getContext().getRequestHeader();
            if (null != profile) {
                context.setProfiles(profile);
            }
            if (null != header) {
                context.setHeaders(header);
                String string = (String)header.get("athena-eoc");
            }
            ServiceUtils.setContext(context);
        } else {
            Map profile;
            Map<String, Object> profiles = context.getProfiles();
            if (ObjectUtil.isEmpty(profiles) && null != (profile = DWServiceContext.getContext().getProfile())) {
                context.setProfiles(profile);
                ServiceUtils.setContext(context);
            }
        }
        return context;
    }

    public static void setContext(DapContext context) {
        profileContext.set(context);
    }

    public static String getLocale() {
        return (String)ServiceUtils.getContext().getHeaders().get("locale");
    }

    public static String getToken() {
        String token = (String)ServiceUtils.getContext().getHeaders().get("token");
        if (null == token) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            token = request.getHeader("token");
        }
        return token;
    }

    public static String getSecurityToken() {
        String token = (String)ServiceUtils.getContext().getHeaders().get("security-token");
        if (null == token) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            token = request.getHeader("security-token");
        }
        return token;
    }

    public static void setLocale(String locale) {
        if (StringUtils.isEmpty((Object)locale)) {
            return;
        }
        ServiceUtils.getContext().getHeaders().put("locale", locale);
    }

    public static String getTenantIdSilent() {
        return (String)ServiceUtils.getContext().getProfiles().get("tenantId");
    }

    public static void setTenantId(String tenantId) {
        ServiceUtils.getContext().getProfiles().put("tenantId", tenantId);
    }

    public static String getTenantId() throws DWBusinessException {
        String tenantId = ServiceUtils.getTenantIdSilent();
        if (tenantId == null || tenantId.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue("datamap.tokenMissingTenantId", new Object[0]));
        }
        return tenantId;
    }

    public static String getUserId() throws DWBusinessException {
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile != null) {
            return profile.getOrDefault("userId", null);
        }
        throw new DWBusinessException("not found userId from token");
    }

    public static Object evalExpressionWithContext(String expression, Map<String, Object> data) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        Map<String, Object> ctx = ServiceUtils.getContext().contextInfo();
        root.put("ctx", ctx);
        if (null != data) {
            root.putAll(data);
        }
        return ServiceUtils.evalExpression(expression, root);
    }

    public static Object evalExpression(String expression, Map<String, Object> data) {
        Object obj = ExpressionUtil.eval((String)expression, data);
        return obj;
    }

    public static <K, V> boolean compareMaps(Map<K, V> map1, Map<K, V> map2) {
        if (ObjectUtil.equals(map1, map2)) {
            return true;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<K, V> entry : map1.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (map2.containsKey(key) && ObjectUtil.equals(map2.get(key), value)) continue;
            return false;
        }
        return true;
    }

    public static Method getSetMethod(Class objectClass, String fieldName) {
        try {
            Class[] parameterTypes = new Class[1];
            Field field = objectClass.getDeclaredField(fieldName);
            parameterTypes[0] = field.getType();
            StringBuffer sb = new StringBuffer();
            sb.append("set");
            sb.append(fieldName.substring(0, 1).toUpperCase());
            sb.append(fieldName.substring(1));
            Method method = objectClass.getMethod(sb.toString(), parameterTypes);
            return method;
        }
        catch (NoSuchFieldException e0) {
            if (objectClass.getSuperclass() != null && !objectClass.getSuperclass().equals(Object.class)) {
                return ServiceUtils.getSetMethod(objectClass.getSuperclass(), fieldName);
            }
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        return null;
    }

    public static List<Field> getFields(Class<?> clazz) {
        Class<?> c = clazz;
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            Field[] fs;
            for (Field f : fs = c.getDeclaredFields()) {
                int mod = f.getModifiers();
                if (Modifier.isStatic(mod) || Modifier.isFinal(mod) || ServiceUtils.isContain(fields, f)) continue;
                fields.add(f);
            }
        } while ((c = c.getSuperclass()) != null);
        return fields;
    }

    public static boolean isContain(List<Field> fieldList, Field field) {
        for (Field temp : fieldList) {
            if (!temp.getName().equals(field.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitive(Class<?> c) {
        if (c != null) {
            return c.isPrimitive() || Number.class.isAssignableFrom(c) || Byte.class.equals(c) || Short.class.equals(c) || Integer.class.equals(c) || Long.class.equals(c) || Boolean.class.equals(c) || Float.class.equals(c) || Double.class.equals(c) || Character.class.isAssignableFrom(c) || CharSequence.class.isAssignableFrom(c) || Date.class.isAssignableFrom(c) || LocalDate.class.isAssignableFrom(c) || LocalDateTime.class.isAssignableFrom(c) || Calendar.class.isAssignableFrom(c);
        }
        return false;
    }

    public static Object getHeader(String header) {
        return DWServiceContext.getContext().getRequestHeader().get(header);
    }

    public static String getEoc() {
        String eoc;
        Map headers;
        if (null == eocHolder.get() && (headers = DWServiceContext.getContext().getRequestHeader()) != null && headers.containsKey("athena-eoc") && null != (eoc = (String)headers.get("athena-eoc"))) {
            eocHolder.set(eoc);
        }
        return eocHolder.get();
    }

    public static void setEoc(String eoc) {
        eocHolder.set(eoc);
    }

    public static boolean isArray(Object v) {
        if (v == null) {
            return false;
        }
        return v instanceof Collection || v.getClass().isArray();
    }

    public static boolean isMapOrObject(Object v) {
        if (v == null) {
            return false;
        }
        return !(v instanceof Collection) && !v.getClass().isArray() && !ServiceUtils.isPrimitive(v.getClass());
    }

    public static String getCurrentLocale() {
        String localeString = "zh_CN";
        Map headers = DWServiceContext.getContext().getRequestHeader();
        if (headers != null && headers.containsKey("locale")) {
            localeString = (String)headers.get("locale");
        }
        return localeString;
    }

    public static <T> T cast(Object obj, Class<T> c) {
        Object t = null;
        if (obj == null) {
            return null;
        }
        t = c.isAssignableFrom(obj.getClass()) ? obj : JSON.parseObject((String)JSON.toJSONString((Object)obj), c);
        return (T)t;
    }

    public static String localeName(Object obj, String field, String locale) {
        String str0;
        Map langField;
        String str = null;
        if (obj == null || null == field) {
            return str;
        }
        Map lang = null;
        if (obj instanceof Map) {
            Map objMap = (Map)obj;
            str = (String)objMap.get(field);
            lang = (Map)objMap.get("lang");
        } else {
            str = (String)ReflectUtil.getFieldValue((Object)obj, (String)field);
            lang = (Map)ReflectUtil.getFieldValue((Object)obj, (String)"lang");
        }
        if (null != lang && null != locale && null != (langField = (Map)lang.get(field)) && null != (str0 = (String)langField.get(locale))) {
            str = str0;
        }
        return str;
    }

    public static void main(String[] args) {
    }
}

