package com.digiwin.athena.kmservice.povo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

//@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class DapResponse <T>{
    private Integer duration;
    private String statusDescription;
    private T response;
    private Object data;
    private DapProfile dapProfile;
    private String uuid;
    private Integer status;
    private String errorMessage;

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public String getStatusDescription() {
        return statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public T getResponse() {
        //DAP框架一个bug,当接口返回null时DAP封装包会实际返回空字符串
        if(response instanceof String && StringUtils.isEmpty((CharSequence) response)){
            return null;
        }
        return response;
    }

    public void setResponse(T response) {
        this.response = response;
    }

    public DapProfile getDapProfile() {
        return dapProfile;
    }

    public void setDapProfile(DapProfile dapProfile) {
        this.dapProfile = dapProfile;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public static DapResponse ok(){
        return DapResponse.builder().status(200).build();
    }

    public static <T> DapResponse ok(T data){
        return DapResponse.builder().status(200).response(data).build();
    }

    public static DapResponse failed(String msg){
        return DapResponse.builder().status(500).statusDescription(msg).build();
    }
}
