package org.neo4j.ogm.impl;

import org.neo4j.ogm.session.request.strategy.LoadClauseBuilder;

/**
因为性能等问题,我们一般只查当前节点指向的节点,方便于spring-data通过约定方法名的方式
 **/

public class PathNodeLoadClauseBuilder implements LoadClauseBuilder {

    public static ThreadLocal<Boolean> original= new ThreadLocal<>();

    public PathNodeLoadClauseBuilder() {
    }

    public String build(String variable, String label, int depth) {
        if(Boolean.TRUE.equals(original.get())){//原来的方式
            if (depth < 0) {
                return " MATCH p=(" + variable + ")-[*0..]-(m) RETURN p";
            } else {
                return depth > 0 ? " MATCH p=(" + variable + ")-[*0.." + depth + "]-(m) RETURN p" : " RETURN n";
            }
        }else{
            if (depth < 0) {//athena定制的方式,只查出的方向
                return " MATCH p=(" + variable + ")-[*0..]->(m) RETURN p";
            } else {
                return depth > 0 ? " MATCH p=(" + variable + ")-[*0.." + depth + "]->(m) RETURN p" : " RETURN n";
            }
        }

    }
}