/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.action.execution;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kg.action.ActionLabel;
import com.digiwin.athena.kg.dto.DataEntityDependencyAndMapsDTO;
import com.digiwin.athena.kg.dto.DataFieldAndMapsDTO;
import com.digiwin.athena.kg.dto.DependencyAndMapsDTO;
import com.digiwin.athena.kg.dto.EntityDependencyDTO;
import com.digiwin.athena.kg.dto.SwitchDependencyAndMapsDTO;
import com.digiwin.athena.kmservice.action.execution.LevelMapping;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionParamDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionPathDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionParamTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.ActionRequestDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ApiDataFieldDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.CaseBranchDTO;
import com.digiwin.athena.kmservice.action.execution.model.CasePullingActionExecutionParamDTO;
import com.digiwin.athena.kmservice.action.execution.model.FieldHanderDTO;
import com.digiwin.athena.kmservice.action.execution.model.MultiPathActionExecutionParamDTO;
import com.digiwin.athena.kmservice.action.execution.model.PullingActionExecutionParamDTO;
import com.digiwin.athena.kmservice.action.metadata.KmActionClient;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.kmservice.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.MergeUtil;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@Scope(value="prototype")
public class KmDataPullingPathGenerator {
    @Autowired(required=false)
    private ActionRepository actionRepository;
    @Autowired
    private KmActionClient actionClient;
    private static final int MAX_ENTITY_FIELD_LEVEL = 3;
    private HashMap<String, ActionExecutionDTO> actions = new HashMap();
    private HashMap<String, ActionDefinitionDTO> actionMetadatas = new HashMap();
    private HashMap<String, Boolean> visitedActionIds = new HashMap();
    private String rootAction = "";

    @Cache(key="action:actionExecutionPath$0$1$2$3", namespace="knowledgegraph", ttlSecs=86400L)
    public ActionExecutionPathDTO Generate(String actionId, String tenantId, List<String> existingActionParamNames, String tenantVersion) throws Exception {
        this.rootAction = actionId;
        this.TryGenerateAction(actionId, tenantId, existingActionParamNames, tenantVersion);
        ActionExecutionPathDTO pathDTO = new ActionExecutionPathDTO();
        pathDTO.setActions(new ArrayList<ActionExecutionDTO>(this.actions.values()));
        pathDTO.setActionMetadatas(new ArrayList<ActionDefinitionDTO>(this.actionMetadatas.values()));
        return pathDTO;
    }

    private boolean TryGenerateAction(String actionId, String tenantId, List<String> existingActionParamNames, String tenantVersion) throws Exception {
        ActionExecutionParamDTO paramDTO;
        String sourceActionId;
        if (this.visitedActionIds.containsKey(actionId)) {
            return this.visitedActionIds.get(actionId);
        }
        this.visitedActionIds.put(actionId, false);
        String actionTenantId = this.QueryAndPutCurrentAction(actionId, tenantId, tenantVersion);
        ActionExecutionDTO executionDTO = this.actions.get(actionId);
        ActionDefinitionDTO metadataDTO = this.actionMetadatas.get(actionId);
        executionDTO.setParams(new ArrayList<ActionExecutionParamDTO>());
        ArrayList<String> processedPullingSourceActionIds = new ArrayList<String>();
        ArrayList<PullingActionExecutionParamDTO> processedPullingParams = new ArrayList<PullingActionExecutionParamDTO>();
        LevelMapping levelMapping = new LevelMapping();
        List<Object> queryResults = this.actionRepository.queryDependencyAndMaps(actionId, actionTenantId, tenantVersion);
        List<DataEntityDependencyAndMapsDTO> queryEntityResults = this.actionRepository.queryDataEntityDependencyAndMaps(actionId, actionTenantId, tenantVersion);
        List queryEntitySourceActionIds = queryEntityResults.parallelStream().map(item -> item.getSourceActionId()).collect(Collectors.toList());
        int originalPullingParamSize = queryResults.size();
        queryResults = queryResults.stream().filter(item -> !queryEntitySourceActionIds.contains(item.getSourceActionId())).collect(Collectors.toList());
        int filteredPullingParamSize = originalPullingParamSize - queryResults.size();
        List<SwitchDependencyAndMapsDTO> querySwitchResults = this.actionRepository.querySwitchDependencyAndMaps(actionId, actionTenantId, tenantVersion);
        Map<String, List<SwitchDependencyAndMapsDTO>> querySwitchResultGroups = querySwitchResults.stream().collect(Collectors.groupingBy(SwitchDependencyAndMapsDTO::getTargetFieldPath));
        HashSet<String> paramsFoundDependency = new HashSet<String>();
        HashSet<String> paramsPullingFoundDependency = new HashSet<String>();
        for (DependencyAndMapsDTO dependencyAndMapsDTO : queryResults) {
            if (StringUtils.isEmpty((CharSequence)dependencyAndMapsDTO.getTargetFieldPath()) || StringUtils.isEmpty((CharSequence)dependencyAndMapsDTO.getSourceFieldPath()) || StringUtils.isEmpty((CharSequence)dependencyAndMapsDTO.getSourceActionId()) || CollectionUtils.isEmpty((Collection)dependencyAndMapsDTO.getSourceActionLabels())) continue;
            String targetFieldPath = dependencyAndMapsDTO.getTargetFieldPath();
            String sourceFieldPath = dependencyAndMapsDTO.getSourceFieldPath();
            sourceActionId = dependencyAndMapsDTO.getSourceActionId();
            List list = dependencyAndMapsDTO.getSourceActionLabels();
            String targetFieldName = targetFieldPath.substring(targetFieldPath.lastIndexOf(".") + 1);
            if ((existingActionParamNames.contains(targetFieldName) || existingActionParamNames.contains(targetFieldPath)) && !paramsFoundDependency.contains(targetFieldPath)) {
                if (StringUtils.isNotEmpty((CharSequence)sourceFieldPath) && this.TryGenerateAction(sourceActionId, tenantId, existingActionParamNames, tenantVersion)) {
                    paramsFoundDependency.add(targetFieldPath);
                    paramDTO = new PullingActionExecutionParamDTO();
                    paramDTO.setType(ActionParamTypeEnum.PULLING);
                    paramDTO.setValue("$." + sourceFieldPath);
                    paramDTO.setName("$." + targetFieldPath);
                    ((PullingActionExecutionParamDTO)paramDTO).setSource(sourceActionId);
                    levelMapping.putPulling(sourceActionId, "$." + targetFieldPath, "$." + sourceFieldPath);
                    executionDTO.getParams().add(paramDTO);
                    continue;
                }
                paramsFoundDependency.add(targetFieldPath);
                paramDTO = new ActionExecutionParamDTO();
                paramDTO.setType(ActionParamTypeEnum.PARAM);
                paramDTO.setValue("$." + sourceFieldPath);
                paramDTO.setName("$." + targetFieldPath);
                if (existingActionParamNames.contains(targetFieldName)) {
                    paramDTO.setValue("$." + targetFieldName);
                } else {
                    paramDTO.setValue("$." + targetFieldPath);
                }
                levelMapping.put(existingActionParamNames, targetFieldPath);
                executionDTO.getParams().add(paramDTO);
                continue;
            }
            if (!this.effectiveAction(list) || paramsFoundDependency.contains(targetFieldPath) || !this.TryGenerateAction(sourceActionId, tenantId, existingActionParamNames, tenantVersion)) continue;
            paramsPullingFoundDependency.add(targetFieldPath);
            PullingActionExecutionParamDTO pullingParamDTO = new PullingActionExecutionParamDTO();
            pullingParamDTO.setType(ActionParamTypeEnum.PULLING);
            pullingParamDTO.setSource(sourceActionId);
            pullingParamDTO.setValue("$." + sourceFieldPath);
            pullingParamDTO.setName("$." + targetFieldPath);
            processedPullingParams.add(pullingParamDTO);
            if (!this.visitedActionIds.containsKey(actionId)) {
                processedPullingSourceActionIds.add(sourceActionId);
            }
            levelMapping.putPulling(sourceActionId, "$." + targetFieldPath, "$." + sourceFieldPath);
        }
        for (DataEntityDependencyAndMapsDTO dataEntityDependencyAndMapsDTO : queryEntityResults) {
            String targetName = dataEntityDependencyAndMapsDTO.getTargetName();
            String sourceName = dataEntityDependencyAndMapsDTO.getSourceName();
            sourceActionId = dataEntityDependencyAndMapsDTO.getSourceActionId();
            List list = dataEntityDependencyAndMapsDTO.getSourceActionLabels();
            if (existingActionParamNames.contains(targetName) && !paramsFoundDependency.contains(targetName)) {
                paramsFoundDependency.add(targetName);
                ActionExecutionParamDTO paramDTO2 = new ActionExecutionParamDTO();
                paramDTO2.setType(ActionParamTypeEnum.PARAM);
                paramDTO2.setName("$." + targetName);
                paramDTO2.setValue("$." + targetName);
                levelMapping.put(existingActionParamNames, targetName);
                executionDTO.getParams().add(paramDTO2);
                continue;
            }
            if (!this.effectiveAction(list) || paramsFoundDependency.contains(targetName) || !this.TryGenerateAction(sourceActionId, tenantId, existingActionParamNames, tenantVersion)) continue;
            paramsPullingFoundDependency.add(targetName);
            PullingActionExecutionParamDTO pullingParamDTO = new PullingActionExecutionParamDTO();
            pullingParamDTO.setType(ActionParamTypeEnum.PULLING);
            pullingParamDTO.setSource(sourceActionId);
            pullingParamDTO.setValue("$." + sourceName);
            pullingParamDTO.setName("$." + targetName);
            processedPullingParams.add(pullingParamDTO);
            if (!this.visitedActionIds.containsKey(actionId)) {
                processedPullingSourceActionIds.add(sourceActionId);
            }
            levelMapping.putPulling(sourceActionId, "$." + targetName, "$." + sourceName);
        }
        for (Map.Entry entry : querySwitchResultGroups.entrySet()) {
            List targetSwitchList = (List)entry.getValue();
            String targetFieldPath = (String)entry.getKey();
            Iterator<DataFieldAndMapsDTO> targetFieldName = targetFieldPath.substring(targetFieldPath.lastIndexOf(".") + 1);
            String string = ((SwitchDependencyAndMapsDTO)targetSwitchList.get(0)).getBoxPullingPath();
            String boxPullingActionId = ((SwitchDependencyAndMapsDTO)targetSwitchList.get(0)).getBoxPullingActionId();
            if ((existingActionParamNames.contains(targetFieldName) || existingActionParamNames.contains(targetFieldPath)) && !paramsFoundDependency.contains(targetFieldPath)) {
                paramsFoundDependency.add(targetFieldPath);
                paramDTO = new ActionExecutionParamDTO();
                paramDTO.setType(ActionParamTypeEnum.PARAM);
                paramDTO.setName(targetFieldPath);
                if (existingActionParamNames.contains(targetFieldName)) {
                    paramDTO.setValue((String)((Object)targetFieldName));
                } else {
                    paramDTO.setValue(targetFieldPath);
                }
                executionDTO.getParams().add(paramDTO);
                continue;
            }
            if (paramsFoundDependency.contains(targetFieldPath)) continue;
            paramsFoundDependency.add(targetFieldPath);
            CasePullingActionExecutionParamDTO casePullingParamDTO = new CasePullingActionExecutionParamDTO();
            casePullingParamDTO.setType(ActionParamTypeEnum.CASE);
            casePullingParamDTO.setName(targetFieldPath);
            HashMap<String, Object> caseInput = new HashMap<String, Object>(4);
            caseInput.put("source", boxPullingActionId);
            caseInput.put("type", (Object)ActionParamTypeEnum.PULLING);
            caseInput.put("value", string);
            casePullingParamDTO.setCaseInput(caseInput);
            this.TryGenerateAction(boxPullingActionId, tenantId, existingActionParamNames, tenantVersion);
            ArrayList<CaseBranchDTO> caseBranchDTOS = new ArrayList<CaseBranchDTO>();
            for (int i = 0; i < targetSwitchList.size(); ++i) {
                SwitchDependencyAndMapsDTO targetRoute = (SwitchDependencyAndMapsDTO)targetSwitchList.get(i);
                List sourceActionLabels2 = targetRoute.getSourceActionLabels();
                String switchName = targetRoute.getSwitchName();
                String sourceActionId2 = targetRoute.getSourceActionId();
                String sourceFieldPath = targetRoute.getSourceFieldPath();
                if (!(sourceActionLabels2.contains("EspAction") || sourceActionLabels2.contains("FormulaAction") || sourceActionLabels2.contains("GetMechanismVariableAction"))) {
                    throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.unsupportedData", new Object[0]) + sourceActionId2);
                }
                HashMap<String, Object> when = new HashMap<String, Object>(4);
                when.put("value", switchName);
                when.put("type", (Object)ActionParamTypeEnum.CONSTANT);
                HashMap<String, Object> then = new HashMap<String, Object>(4);
                then.put("source", sourceActionId2);
                then.put("type", (Object)ActionParamTypeEnum.PULLING);
                then.put("value", sourceFieldPath);
                CaseBranchDTO caseBranchDTO = new CaseBranchDTO();
                caseBranchDTO.setWhen(when);
                caseBranchDTO.setThen(then);
                caseBranchDTOS.add(caseBranchDTO);
                this.TryGenerateAction(sourceActionId2, tenantId, existingActionParamNames, tenantVersion);
            }
            casePullingParamDTO.setCaseBranches(caseBranchDTOS);
            executionDTO.getParams().add(casePullingParamDTO);
        }
        ActionRequestDefinitionDTO requestDefinitionDTO = metadataDTO.getRequest();
        for (ApiDataFieldDefinitionDTO definitionDTO : requestDefinitionDTO.getParameters()) {
            List<String> fieldFullPaths = this.GetFieldFullPath(definitionDTO, null);
            for (String string : fieldFullPaths) {
                ActionExecutionParamDTO paramDTO2;
                String targetFieldName;
                String fieldName = string.contains(".") ? string.substring(string.lastIndexOf(".") + 1) : string;
                String string2 = targetFieldName = string.contains("#") ? string.substring(string.lastIndexOf("#") + 1) : string;
                if (existingActionParamNames.contains(string) && !paramsFoundDependency.contains(string)) {
                    paramsFoundDependency.add(string);
                    ActionExecutionParamDTO paramDTO3 = new ActionExecutionParamDTO();
                    paramDTO3.setType(ActionParamTypeEnum.PARAM);
                    paramDTO3.setName("$." + string);
                    paramDTO3.setValue("$." + string);
                    levelMapping.put(existingActionParamNames, string);
                    executionDTO.getParams().add(paramDTO3);
                } else if (existingActionParamNames.contains(fieldName) && !paramsFoundDependency.contains(string)) {
                    paramsFoundDependency.add(string);
                    paramDTO2 = new ActionExecutionParamDTO();
                    paramDTO2.setType(ActionParamTypeEnum.PARAM);
                    paramDTO2.setName("$." + string);
                    paramDTO2.setValue("$." + fieldName);
                    levelMapping.put(existingActionParamNames, string);
                    executionDTO.getParams().add(paramDTO2);
                } else if (existingActionParamNames.contains(targetFieldName) && !paramsFoundDependency.contains(string) && !Objects.equals(Boolean.TRUE, this.effectiveActionParam(string, processedPullingParams))) {
                    paramsFoundDependency.add(string);
                    paramDTO2 = new ActionExecutionParamDTO();
                    paramDTO2.setType(ActionParamTypeEnum.PARAM);
                    paramDTO2.setName("$." + string);
                    paramDTO2.setValue("$." + targetFieldName);
                    levelMapping.put(existingActionParamNames, (StringUtils.isNotEmpty((CharSequence)string) ? string.substring(0, string.indexOf(".") + 1) : string) + targetFieldName);
                    executionDTO.getParams().add(paramDTO2);
                }
                this.matchField(existingActionParamNames, paramsFoundDependency, string, levelMapping, executionDTO);
            }
        }
        FieldHanderDTO fieldHanderDTO = this.levelTraverseParamFieldsHandler(metadataDTO);
        int paramsCount = fieldHanderDTO.getCount();
        if (paramsFoundDependency.size() + paramsPullingFoundDependency.size() < paramsCount) {
            List<DataFieldAndMapsDTO> queryEntityDependencyResults = this.actionRepository.queryDataFieldAndMaps(actionId, actionTenantId, tenantVersion);
            for (DataFieldAndMapsDTO dataFieldAndMapsDTO : queryEntityDependencyResults) {
                String targetFieldFullPath = dataFieldAndMapsDTO.getTargetFieldFullPath();
                String mapFieldFullPath = dataFieldAndMapsDTO.getMapFieldFullPath();
                String mapFieldName = dataFieldAndMapsDTO.getMapFieldName();
                if (paramsFoundDependency.contains(targetFieldFullPath) || paramsPullingFoundDependency.contains(targetFieldFullPath)) continue;
                String existingActionParamMatched = null;
                List<String> sourceIds = this.actionRepository.queryActionIdByRequiredField(String.valueOf(dataFieldAndMapsDTO.getMapFieldId()), actionTenantId, tenantVersion);
                for (String existingActionParamName : existingActionParamNames) {
                    String paramName;
                    String string = paramName = existingActionParamName.contains(".") ? existingActionParamName.substring(existingActionParamName.lastIndexOf(".") + 1) : existingActionParamName;
                    if (!paramName.equals(mapFieldName) && !existingActionParamName.equals(mapFieldFullPath) || !CollectionUtils.isEmpty(sourceIds) && !sourceIds.contains(this.rootAction)) continue;
                    existingActionParamMatched = existingActionParamName;
                    break;
                }
                if (existingActionParamMatched == null || paramsFoundDependency.contains(targetFieldFullPath)) continue;
                paramsFoundDependency.add(targetFieldFullPath);
                ActionExecutionParamDTO paramDTO4 = new ActionExecutionParamDTO();
                paramDTO4.setType(ActionParamTypeEnum.PARAM);
                paramDTO4.setName("$." + targetFieldFullPath);
                paramDTO4.setValue("$." + existingActionParamMatched);
                levelMapping.put(existingActionParamMatched, targetFieldFullPath);
                executionDTO.getParams().add(paramDTO4);
            }
        }
        List<EntityDependencyDTO> entityDependencyDTOList = this.actionRepository.queryEntityDependency(actionId, actionTenantId, tenantVersion);
        for (EntityDependencyDTO entityDependencyDTO : entityDependencyDTOList) {
            String entityFullPath = entityDependencyDTO.getTargetEntityFullPath();
            if (!existingActionParamNames.contains(entityFullPath) || paramsFoundDependency.contains(entityFullPath)) continue;
            paramsFoundDependency.add(entityFullPath);
            paramDTO = new ActionExecutionParamDTO();
            paramDTO.setType(ActionParamTypeEnum.PARAM);
            paramDTO.setName("$." + entityFullPath);
            paramDTO.setValue("$." + entityFullPath);
            levelMapping.put(existingActionParamNames, entityFullPath);
            executionDTO.getParams().add(paramDTO);
            filteredPullingParamSize += entityDependencyDTO.getTargetFieldFullPaths().size() - 1;
        }
        boolean pullingSucceeded = paramsFoundDependency.size() + paramsPullingFoundDependency.size() + filteredPullingParamSize >= paramsCount;
        boolean bl = pullingSucceeded = pullingSucceeded ? true : this.hasFoundAllRequiredParams(paramsFoundDependency, paramsPullingFoundDependency, fieldHanderDTO.getRequiredFieldFullPathSet());
        if (!pullingSucceeded && !actionId.equals(this.rootAction)) {
            for (String sourceActionId3 : processedPullingSourceActionIds) {
                if (sourceActionId3.equals(this.rootAction)) continue;
                this.actions.remove(sourceActionId3);
                this.actionMetadatas.remove(sourceActionId3);
                this.visitedActionIds.remove(sourceActionId3);
            }
            this.actions.remove(actionId);
            this.actionMetadatas.remove(actionId);
            this.visitedActionIds.replace(actionId, false);
        } else {
            List<ActionExecutionParamDTO> list = levelMapping.generate();
            Map<String, List<PullingActionExecutionParamDTO>> afterGroupingPulling = processedPullingParams.stream().collect(Collectors.groupingBy(e -> e.getName()));
            for (Map.Entry<String, List<PullingActionExecutionParamDTO>> entry : afterGroupingPulling.entrySet()) {
                if (entry.getValue().size() > 1) {
                    MultiPathActionExecutionParamDTO multiPathActionExecutionParamDTO = new MultiPathActionExecutionParamDTO();
                    multiPathActionExecutionParamDTO.setName(entry.getKey());
                    multiPathActionExecutionParamDTO.setType(ActionParamTypeEnum.MULTIPATH);
                    multiPathActionExecutionParamDTO.setValues(entry.getValue());
                    executionDTO.getParams().add(multiPathActionExecutionParamDTO);
                    continue;
                }
                executionDTO.getParams().addAll((Collection<ActionExecutionParamDTO>)entry.getValue());
            }
            if (!CollectionUtils.isEmpty(executionDTO.getParams())) {
                executionDTO.getParams().addAll(list);
            }
            this.visitedActionIds.replace(actionId, true);
        }
        return pullingSucceeded;
    }

    private boolean effectiveActionParam(String fieldFullPath, List<PullingActionExecutionParamDTO> processedPullingParams) {
        if (CollectionUtils.isEmpty(processedPullingParams)) {
            return Boolean.FALSE;
        }
        for (PullingActionExecutionParamDTO pullingActionParam : processedPullingParams) {
            if (!StringUtils.equals((CharSequence)("$." + fieldFullPath), (CharSequence)pullingActionParam.getName())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void matchField(List<String> existingActionParamNames, Set<String> paramsFoundDependency, String fieldFullPath, LevelMapping levelMapping, ActionExecutionDTO executionDTO) {
        if (StringUtils.isEmpty((CharSequence)fieldFullPath)) {
            return;
        }
        String path = fieldFullPath;
        while (StringUtils.isNotEmpty((CharSequence)path) && !paramsFoundDependency.contains(path)) {
            if (existingActionParamNames.contains(path) && !paramsFoundDependency.contains(path)) {
                paramsFoundDependency.add(fieldFullPath);
                ActionExecutionParamDTO paramDTO = new ActionExecutionParamDTO();
                paramDTO.setType(ActionParamTypeEnum.PARAM);
                paramDTO.setName("$." + fieldFullPath);
                paramDTO.setValue("$." + path);
                levelMapping.put(path, fieldFullPath);
                executionDTO.getParams().add(paramDTO);
                return;
            }
            path = StringUtils.substringAfter((String)path, (String)".");
        }
    }

    private List<String> GetFieldFullPath(ApiDataFieldDefinitionDTO fieldDTO, String path) {
        String name = fieldDTO.getData_name();
        if (path != null) {
            name = path + "." + name;
        }
        ArrayList<String> fieldFullPaths = new ArrayList<String>();
        if (fieldDTO.getField() != null && fieldDTO.getField().size() != 0) {
            for (ApiDataFieldDefinitionDTO detailField : fieldDTO.getField()) {
                fieldFullPaths.addAll(this.GetFieldFullPath(detailField, name));
            }
        } else {
            fieldFullPaths.add(name);
        }
        return fieldFullPaths;
    }

    public String QueryAndPutCurrentAction(String actionId, String tenantId, String tenantVersion) throws Exception {
        List<ActionLabel> actionAndLabels = this.actionRepository.getActionAndLabels(actionId, tenantId, tenantVersion);
        if ((actionAndLabels = MergeUtil.excludeWithSameCode(actionAndLabels, actionLabel -> actionLabel.getAction().getActionId(), actionLabel -> actionLabel.getAction().getSourceLevel())).isEmpty()) {
            throw new DWException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.actionNotFound", actionId, tenantId));
        }
        ActionLabel actionLabel2 = actionAndLabels.get(0);
        Map actionMatched = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)actionLabel2.getAction()), Map.class);
        String currentActionTenantId = MapUtil.getStr((Map)actionMatched, (Object)"tenantId");
        actionMatched.put("tenantId", tenantId);
        List actionLabels = actionLabel2.getActionLabels();
        this.actionMetadatas.put(actionId, this.actionClient.doHandlerMetadata(actionLabels, actionMatched));
        this.actions.put(actionId, this.actionClient.doHandlerExecution(actionLabels, actionMatched));
        return currentActionTenantId;
    }

    private boolean hasFoundAllRequiredParams(Set<String> paramsFoundDependency, Set<String> requiredFieldFullPathSet) {
        if (CollectionUtils.isEmpty(requiredFieldFullPathSet)) {
            return true;
        }
        Iterator<String> iterator = requiredFieldFullPathSet.iterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (!paramsFoundDependency.contains(next)) continue;
            iterator.remove();
        }
        return CollectionUtils.isEmpty(requiredFieldFullPathSet);
    }

    private boolean hasFoundAllRequiredParams(Set<String> paramsFoundDependency, Set<String> paramsPullingFoundDependency, Set<String> requiredFieldFullPathSet) {
        if (CollectionUtils.isEmpty(requiredFieldFullPathSet)) {
            return true;
        }
        Iterator<String> iterator = requiredFieldFullPathSet.iterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (paramsFoundDependency.contains(next)) {
                iterator.remove();
            }
            if (!paramsPullingFoundDependency.contains(next)) continue;
            iterator.remove();
        }
        return CollectionUtils.isEmpty(requiredFieldFullPathSet);
    }

    private FieldHanderDTO levelTraverseParamFieldsHandler(ActionDefinitionDTO metadataDTO) {
        int count = 0;
        HashSet<String> requiredFieldFullPath = new HashSet<String>();
        HashMap<String, String> prefixPathMap = new HashMap<String, String>();
        LinkedList<ApiDataFieldDefinitionDTO> queue = new LinkedList<ApiDataFieldDefinitionDTO>();
        List<ApiDataFieldDefinitionDTO> parameters = metadataDTO.getRequest().getParameters();
        for (ApiDataFieldDefinitionDTO parameter : parameters) {
            if (parameter.getData_type().equals("object")) {
                queue.offer(parameter);
                prefixPathMap.put(parameter.getData_name(), parameter.getData_name() + ".");
                continue;
            }
            ++count;
            if (!StringUtils.equalsIgnoreCase((CharSequence)parameter.getRequired(), (CharSequence)"true")) continue;
            requiredFieldFullPath.add(parameter.getData_name());
        }
        while (!queue.isEmpty()) {
            ApiDataFieldDefinitionDTO dto = (ApiDataFieldDefinitionDTO)queue.poll();
            String prefix = prefixPathMap.getOrDefault(dto.getData_name(), "");
            for (ApiDataFieldDefinitionDTO parameter : dto.getField()) {
                if (parameter.getData_type().equals("object")) {
                    queue.offer(parameter);
                    prefixPathMap.put(parameter.getData_name(), prefix + parameter.getData_name() + ".");
                    continue;
                }
                ++count;
                if (!StringUtils.equalsIgnoreCase((CharSequence)parameter.getRequired(), (CharSequence)"true")) continue;
                requiredFieldFullPath.add(prefix + parameter.getData_name());
            }
        }
        return new FieldHanderDTO(count, requiredFieldFullPath);
    }

    private int levelTraverseParamFieldsCount(ActionDefinitionDTO metadataDTO) {
        int count = 0;
        LinkedList<ApiDataFieldDefinitionDTO> queue = new LinkedList<ApiDataFieldDefinitionDTO>();
        List<ApiDataFieldDefinitionDTO> parameters = metadataDTO.getRequest().getParameters();
        for (ApiDataFieldDefinitionDTO parameter : parameters) {
            if (parameter.getData_type().equals("object")) {
                queue.offer(parameter);
                continue;
            }
            ++count;
        }
        while (!queue.isEmpty()) {
            ApiDataFieldDefinitionDTO dto = (ApiDataFieldDefinitionDTO)queue.poll();
            for (ApiDataFieldDefinitionDTO parameter : dto.getField()) {
                if (parameter.getData_type().equals("object")) {
                    queue.offer(parameter);
                    continue;
                }
                ++count;
            }
        }
        return count;
    }

    private static int countParamFields(ActionDefinitionDTO metadata) {
        int count = 0;
        List<ApiDataFieldDefinitionDTO> parameters = metadata.getRequest().getParameters();
        for (ApiDataFieldDefinitionDTO parameter : parameters) {
            count += KmDataPullingPathGenerator.countParamFields(parameter);
        }
        return count;
    }

    private static int countParamFields(ApiDataFieldDefinitionDTO field) {
        int count = 0;
        if (field.getData_type().equals("object")) {
            for (ApiDataFieldDefinitionDTO parameter : field.getField()) {
                count += KmDataPullingPathGenerator.countParamFields(parameter);
            }
            return count;
        }
        return 1;
    }

    private boolean effectiveAction(List<String> sourceActionLabels) {
        return sourceActionLabels.contains("EspAction") || sourceActionLabels.contains("FormulaAction") || sourceActionLabels.contains("GetMechanismVariableAction") || sourceActionLabels.contains("IamAction") || sourceActionLabels.contains("EocAction") || sourceActionLabels.contains("TaskDataGroupAction") || sourceActionLabels.contains("DataPullingAction") || sourceActionLabels.contains("StartServiceComposerAction") || sourceActionLabels.contains("StartDataEventAction") || sourceActionLabels.contains("TransformAction") || sourceActionLabels.contains("MicroTransformAction") || sourceActionLabels.contains("BmdGeneralAction") || sourceActionLabels.contains("BmdAction") || sourceActionLabels.contains("FormulacAction") || sourceActionLabels.contains("SQLAction") || sourceActionLabels.contains("MetricAction") || sourceActionLabels.contains("BmdApiAction") || sourceActionLabels.contains("InPutAction") || sourceActionLabels.contains("BizParamAction");
    }
}

