/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.utils;

import com.digiwin.athena.domain.common.BaseObject;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslateUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TranslateUtil.class);
    static ThreadLocal<Boolean> disAbleLangLocal = new InheritableThreadLocal<Boolean>();

    public static void disableLang(Boolean disLang) {
        disAbleLangLocal.set(disLang);
    }

    public static boolean isDisableLang() {
        return Boolean.TRUE.equals(disAbleLangLocal.get());
    }

    public static void dealLangRecusive(Object entity, String locale) {
        if (null == entity || null == locale || ServiceUtils.isPrimitive(entity.getClass())) {
            return;
        }
        if (entity instanceof BaseObject) {
            TranslateUtil.dealLang((BaseObject)entity, locale);
            TranslateUtil.dealFields(entity, locale);
        } else if (entity instanceof Collection) {
            Collection collection = (Collection)entity;
            for (Object obj : collection) {
                TranslateUtil.dealLangRecusive(obj, locale);
            }
        } else if (entity.getClass().isArray()) {
            Object[] arr;
            for (Object obj : arr = (Object[])entity) {
                TranslateUtil.dealLangRecusive(obj, locale);
            }
        } else if (entity instanceof Map) {
            Map map = (Map)entity;
            try {
                Map lang = null;
                if (map.get("lang") != null && map.get("lang") instanceof Map) {
                    lang = (Map)map.get("lang");
                } else if (map.get("language") != null && map.get("language") instanceof Map) {
                    lang = (Map)map.get("language");
                }
                if (lang != null) {
                    lang.forEach((k, m) -> {
                        if (null != m.get(locale)) {
                            map.put(k, m.get(locale));
                        } else if (null != m.get(locale.toLowerCase())) {
                            map.put(k, m.get(locale));
                        }
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Object obj : map.values()) {
                TranslateUtil.dealLangRecusive(obj, locale);
            }
        } else {
            TranslateUtil.dealFields(entity, locale);
        }
    }

    private static void dealFields(Object entity, String locale) {
        List<Field> fields = ServiceUtils.getFields(entity.getClass());
        for (Field f : fields) {
            f.setAccessible(true);
            try {
                Object obj = f.get(entity);
                TranslateUtil.dealLangRecusive(obj, locale);
            }
            catch (IllegalAccessException e) {
                log.error(e.toString());
            }
        }
    }

    private static void dealLang(BaseObject entity, String locale) {
        if (null != entity && null != locale) {
            Map lang = entity.getLang();
            if (null == lang) {
                lang = entity.getLanguage();
            }
            if (null != lang) {
                lang.forEach((k, v) -> {
                    Method method;
                    String langName;
                    if (v != null && (langName = (String)v.get(locale)) != null && null != (method = ServiceUtils.getSetMethod(entity.getClass(), k))) {
                        try {
                            method.invoke((Object)entity, langName);
                        }
                        catch (Exception e) {
                            log.error(e.toString());
                        }
                    }
                });
            }
        }
    }
}

