package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.kg.action.ActionLabel;
import com.digiwin.athena.kg.action.ESPServiceVO;
import com.digiwin.athena.kg.action.StartDataEventAction;
import com.digiwin.athena.kg.dto.*;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.kg.action.ActionConfig;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

@Repository
public interface ActionRepository extends Neo4jRepository<Action,Long> {

    @Query("match(n:Action {actionId:$0, version: $1}) RETURN n")
    List<Action> getActionByActionId(String actionId, String version);

    @Query("match(a:Action) where a.actionId in $0 return a")
    List<Action> getActionByActionIds(Set<String> actionIds);

    List<Action> findOneByActionId(String actionId);

    List<Action> findByActionId(String actionId);

    List<Action> findByActionIdAndVersion(String actionId, String version);

    @Query("MATCH (action:Action) where action.ruleId = $0 return action, labels(action) as actionLabels, action.sourceLevel as sourceLevel")
    List<ActionLabel> getActionAndLabelsByRuleId(String ruleId);

    @Query("MATCH (action:Action) where action.actionId = $0 return action, labels(action) as actionLabels, action.sourceLevel as sourceLevel")
    List<ActionLabel> getActionAndLabels(String actionId);

    @Query("MATCH (action:StartDataEventAction) where action.actionId = $0 return action")
    List<StartDataEventAction> getDataMapAction(String actionId);

    //    @Query("MATCH (:TenantEntity{tenantId:$1})-[:ACTION]->(action:Action{version:$2}) where action.actionId = $0 return action, labels(action) as actionLabels " +
//            "UNION " +
//            "MATCH (:TenantEntity{ifCommon:true,version:$2})-[:ACTION]->(action:Action{version:$2}) where action.actionId = $0 return action, labels(action) as actionLabels")
    @Query("MATCH (action:Action{version:$2}) where  action.actionId = $0 and (action.tenantId in ['SYSTEM',$1] or action.tenantId is null) return action, labels(action) as actionLabels, action.sourceLevel as sourceLevel ")
    List<ActionLabel> getActionAndLabels(String actionId, String tenantId, String tenantVersion);

    //    @Query("MATCH (:TenantEntity{tenantId:$1})-[:ACTION]->(action:Action{version:$2}) where action.actionId in $0 return action, labels(action) as actionLabels " +
//            "UNION " +
//            "MATCH (:TenantEntity{ifCommon:true,version:$2})-[:ACTION]->(action:Action{version:$2}) where action.actionId in $0 return action, labels(action) as actionLabels")
    @Query("MATCH(action:Action{version:$2}) where  action.actionId in $0  and (action.tenantId in ['SYSTEM',$1] or action.tenantId is null) return action, labels(action) as actionLabels, action.sourceLevel as sourceLevel ")
    List<ActionLabel> getActionAndLabels(List<String> actionIds, String tenantId, String tenantVersion);

    @Query("match (nextAction:Action)-[:Requires]->()-[r1:Contains*0..3]->(targetField:DataField)-[:MapsTo]->(sourceField:DataField)<-[:Contains*0..3]-()<-[:Creates]-(sourceAction:Action) " +
            "where nextAction.actionId = $0  return targetField.fullPath as targetFieldPath,sourceField.fullPath as sourceFieldPath, sourceAction.actionId as sourceActionId, labels(sourceAction) as sourceActionLabels")
    List<DependencyAndMapsDTO> queryDependencyAndMaps(String actionId);

    //    @Query("match (a:TenantEntity)-[:ACTION]->(nextAction:Action{version:$2})-[:Requires]->()-[r1:Contains*0..3]->(targetField:DataField)-[:MapsTo]->(sourceField:DataField)<-[:Contains*0..3]-()<-[:Creates]-(sourceAction:Action)<-[:ACTION]-(b:TenantEntity) " +
//            "where (a.tenantId = $1 or (a.ifCommon=true and a.version = $2)) and (b.tenantId = $1 or (b.ifCommon=true and b.version = $2)) and nextAction.actionId = $0  return targetField.fullPath as targetFieldPath,sourceField.fullPath as sourceFieldPath, sourceAction.actionId as sourceActionId, labels(sourceAction) as sourceActionLabels")
    @Query("match (nextAction:Action{version:$2})-[:Requires]->()-[r1:Contains*0..3]->(targetField:DataField)-[:MapsTo]->(sourceField:DataField)<-[:Contains*0..3]-()<-[:Creates]-(sourceAction:Action{tenantId:$1}) " +
            "where  nextAction.actionId = $0 and nextAction.tenantId = $1 return targetField.fullPath as targetFieldPath,sourceField.fullPath as sourceFieldPath, sourceAction.actionId as sourceActionId, labels(sourceAction) as sourceActionLabels")
    List<DependencyAndMapsDTO> queryDependencyAndMaps(String actionId, String tenantId, String tenantVersion);

    @Query("match (nextAction:Action)-[:Requires]->(tde:DataEntity)-[:MapsTo]->(sde:DataEntity)<-[:Creates]-(sourceAction:Action) " +
            "where nextAction.actionId = $0 return tde.name as targetName,sde.name as sourceName, sourceAction.actionId as sourceActionId, labels(sourceAction) as sourceActionLabels")
    List<DataEntityDependencyAndMapsDTO> queryDataEntityDependencyAndMaps(String actionId);

    //    @Query("match (a:TenantEntity)-[:ACTION]->(nextAction:Action{version:$2})-[:Requires]->(tde:DataEntity)-[:MapsTo]->(sde:DataEntity)<-[:Creates]-(sourceAction:Action)<-[:ACTION]-(b:TenantEntity) " +
//            "where (a.tenantId = $1 or (a.ifCommon=true and a.version = $2)) and (b.tenantId = $1 or (b.ifCommon=true and b.version = $2)) and nextAction.actionId = $0 return tde.name as targetName,sde.name as sourceName, sourceAction.actionId as sourceActionId, labels(sourceAction) as sourceActionLabels")
    @Query("match(nextAction:Action{version:$2})-[:Requires]->(tde:DataEntity)-[:MapsTo]->(sde:DataEntity)<-[:Creates]-(sourceAction:Action{tenantId:$1}) " +
            "where nextAction.actionId = $0 and nextAction.tenantId = $1 return tde.name as targetName,sde.name as sourceName, sourceAction.actionId as sourceActionId, labels(sourceAction) as sourceActionLabels")
    List<DataEntityDependencyAndMapsDTO> queryDataEntityDependencyAndMaps(String actionId, String tenantId, String tenantVersion);


    @Query("match (nextAction:Action)-[:Requires]->()-[r1:Contains*0..3]->(targetField:DataField)-[:MapsTo]->(switchBox:SwitchBox)-[:CaseWhen]->(cv:CaseValue)-[:CaseThen]->(sourceField:DataField)<-[:Contains*0..3]-()<-[:Creates]-(sourceAction:Action), " +
            "(switchBox)-[:Pulling]->(boxData:DataField)<-[:Contains*0..3]-()<-[:Creates]-(switchSourceAction:Action) " +
            "where nextAction.actionId = $0" +
            " return targetField.fullPath as targetFieldPath,sourceField.fullPath as sourceFieldPath,sourceAction.actionId as sourceActionId, cv.name as switchName, labels(sourceAction) as sourceActionLabels,boxData.fullPath as boxPullingPath, switchSourceAction.actionId as boxPullingActionId")
    List<SwitchDependencyAndMapsDTO> querySwitchDependencyAndMaps(String actionId);

    //    @Query("match (a:TenantEntity)-[:ACTION]->(nextAction:Action{version:$2})-[:Requires]->()-[r1:Contains*0..3]->(targetField:DataField)-[:MapsTo]->(switchBox:SwitchBox)-[:CaseWhen]->(cv:CaseValue)-[:CaseThen]->(sourceField:DataField)<-[:Contains*0..3]-()<-[:Creates]-(sourceAction:Action)<-[:ACTION]-(b:TenantEntity), " +
//            "(switchBox)-[:Pulling]->(boxData:DataField)<-[:Contains*0..3]-()<-[:Creates]-(switchSourceAction:Action)<-[:ACTION]-(c:TenantEntity) " +
//            "where (a.tenantId = $1 or (a.ifCommon=true and a.version = $2)) and (b.tenantId = $1 or (b.ifCommon=true and b.version = $2)) and (c.tenantId = $1 or (c.ifCommon=true or c.version = $2)) and nextAction.actionId = $0" +
//            " return targetField.fullPath as targetFieldPath,sourceField.fullPath as sourceFieldPath,sourceAction.actionId as sourceActionId, cv.name as switchName, labels(sourceAction) as sourceActionLabels,boxData.fullPath as boxPullingPath, switchSourceAction.actionId as boxPullingActionId")
    @Query("match (nextAction:Action{version:$2})-[:Requires]->()-[r1:Contains*0..3]->(targetField:DataField)-[:MapsTo]->(switchBox:SwitchBox)-[:CaseWhen]->(cv:CaseValue)-[:CaseThen]->(sourceField:DataField)<-[:Contains*0..3]-()<-[:Creates]-(sourceAction:Action{tenantId:$1}), " +
            "(switchBox)-[:Pulling]->(boxData:DataField)<-[:Contains*0..3]-()<-[:Creates]-(switchSourceAction:Action{tenantId:$1}) " +
            "where  nextAction.actionId = $0 and nextAction.tenantId = $1 " +
            " return targetField.fullPath as targetFieldPath,sourceField.fullPath as sourceFieldPath,sourceAction.actionId as sourceActionId, cv.name as switchName, labels(sourceAction) as sourceActionLabels,boxData.fullPath as boxPullingPath, switchSourceAction.actionId as boxPullingActionId")
    List<SwitchDependencyAndMapsDTO> querySwitchDependencyAndMaps(String actionId, String tenantId, String tenantVersion);


    @Query("match (nextAction:Action)-[:Requires]->(targetEntity:DataEntity)-[:Contains]->(targetField:DataField) " +
            "where nextAction.actionId = $0 return targetEntity.name as targetEntityName, collect(targetField.fullPath) as targetFieldFullPaths")
    List<EntityDependencyDTO> queryEntityDependency(String actionId);

    //    @Query("match (a:TenantEntity)-[:ACTION]->(nextAction:Action{version:$2})-[:Requires]->()-[r1:Contains*0..3]->(targetEntity:DataEntity)-[:Contains]->(targetField:DataField) " +
//            "where (a.tenantId = $1 or (a.ifCommon=true and a.version = $2)) and nextAction.actionId = $0 return targetEntity.name as targetEntityName, targetEntity.fullPath as targetEntityFullPath, collect(targetField.fullPath) as targetFieldFullPaths")
    @Query("match (nextAction:Action{version:$2})-[:Requires]->()-[r1:Contains*0..3]->(targetEntity:DataEntity)-[:Contains]->(targetField:DataField) " +
            "where  nextAction.actionId = $0 and (nextAction.tenantId in ['SYSTEM',$1] or nextAction.tenantId is null) return targetEntity.name as targetEntityName, targetEntity.fullPath as targetEntityFullPath, collect(targetField.fullPath) as targetFieldFullPaths")
    List<EntityDependencyDTO> queryEntityDependency(String actionId, String tenantId, String tenantVersion);

    //    @Query("match (:TenantEntity{tenantId:$1})-[:ACTION]->(nextAction:Action)-[:Requires]->()-[r1:Contains*0..3]->(de:DataEntity) " +
//            "where nextAction.actionId = $0 return de.fullPath as targetEntityFullPath")
    @Query("match (nextAction:Action)-[:Requires]->()-[r1:Contains*0..3]->(de:DataEntity) " +
            "where nextAction.actionId = $0 and (nextAction.tenantId in ['SYSTEM',$1] or nextAction.tenantId is null) return de.fullPath as targetEntityFullPath")
    List<String> queryDataEntitys(String actionId, String tenantId);

    @Query("match (nextAction:Action)-[:Requires]->(targetField:DataField)-[:MapsTo]->(mapField:DataField) " +
            "where nextAction.actionId = $0 return targetField.name as targetFieldName, targetField.fullPath as targetFieldFullPath, mapField.name as mapFieldName, mapField.fullPath as mapFieldFullPath, id(mapField) as mapFieldId")
    List<DataFieldAndMapsDTO> queryDataFieldAndMaps(String actionId);

    //    @Query("match (a:TenantEntity)-[:ACTION]->(nextAction:Action{version:$2})-[:Requires]->()-[r1:Contains*0..3]->(targetField:DataField)-[:MapsTo]->(mapField:DataField) " +
//            "where (a.tenantId = $1 or (a.ifCommon=true and a.version = $2)) and nextAction.actionId = $0 return targetField.name as targetFieldName, targetField.fullPath as targetFieldFullPath, mapField.name as mapFieldName, mapField.fullPath as mapFieldFullPath, id(mapField) as mapFieldId")
    @Query("match (nextAction:Action{version:$2})-[:Requires]->()-[r1:Contains*0..3]->(targetField:DataField)-[:MapsTo]->(mapField:DataField) " +
            "where nextAction.actionId = $0 and (nextAction.tenantId in ['SYSTEM',$1] or nextAction.tenantId is null) return targetField.name as targetFieldName, targetField.fullPath as targetFieldFullPath, mapField.name as mapFieldName, mapField.fullPath as mapFieldFullPath, id(mapField) as mapFieldId")

    List<DataFieldAndMapsDTO> queryDataFieldAndMaps(String actionId, String tenantId, String tenantVersion);

    @Query("match (action:Action)-[:ACTIONCONFIG]->(config:ActionConfig) where action.actionId=$0 return config limit 1")
    ActionConfig queryActionConfig(String actionId);

    //    @Query("match (:TenantEntity{tenantId:$1})-[:ACTION]->(action:Action)-[:ACTIONCONFIG]->(config:ActionConfig) where action.actionId=$0 return config limit 1")
    @Query("match (action:Action)-[:ACTIONCONFIG]->(config:ActionConfig) where action.actionId=$0  and (action.tenantId in ['SYSTEM',$1] or action.tenantId is null) return config limit 1")
    ActionConfig queryActionConfig(String actionId, String tenantId);

    @Query("match (action:Action)-[:Requires]->(f:DataField) where id(f)=$0 return action.actionId")
    List<String> queryActionIdByRequiredField(String fieldId);

    //    @Query("match (a:TenantEntity)-[:ACTION]->(action:Action{version:$2})-[:Requires]->(f:DataField) where (a.tenantId = $1 or (a.ifCommon=true and a.version = $2)) and id(f)=$0 return action.actionId")
    @Query("match (action:Action{version:$2})-[:Requires]->(f:DataField) where  id(f)=$0  and (action.tenantId in ['SYSTEM',$1] or action.tenantId is null) return action.actionId")
    List<String> queryActionIdByRequiredField(String fieldId, String tenantId, String tenantVersion);

    //    @Query("match (a:TenantEntity)-[:ACTION]->(action:EspAction{version:$2}) where a.tenantId = $0 or (a.ifCommon=true and a.version = $2) return action.serviceName as serviceName, " +
//            "case when $1 = 'zh_CN' then action.actionName else action.actionName_tw end as serviceDesc")
    @Query("match (action:EspAction{version:$2}) where action.tenantId in ['SYSTEM',$0] or action.tenantId is null return action.serviceName as serviceName, " +
            "case when $1 = 'zh_CN' then action.actionName else action.actionName_tw end as serviceDesc")
    List<ESPServiceVO> queryEspService(String tenantId, String locale, String tenantVersion);


    @Query("MATCH (action:TaskDataGroupAction) where action.taskId = $0 return action")
    List<Action> getTaskDataGroupAction(String taskId);

    @Query("match (m:MonitorRule)-[:Triggers]->(a:Action) where m.code = $0 return a")
    Action getMonitorTriggerAction(String ruleCode);

    @Query("match (m:MonitorRule) where m.code = $0 and m.version = $1 return m.sourceIdKey")
    String getSourceIdKey(String ruleCode, String version);


    @Query("MATCH (action:Action{version:$1}) where action.actionId in $0 return action")
    List<Action> getActions(List<String> actionId, String tenantVersion);

    @Query("MATCH(action:Action{version:$2}) where  action.dataFlowCode in $0  and (action.tenantId in ['SYSTEM',$1] or action.tenantId is null) return action, labels(action) as actionLabels ")
    List<ActionLabel> getActionAndLabelsByDataFlowCode(List<String> dataFlowCodes, String tenantId, String tenantVersion);

    @Query("MATCH(action:Action{version:$2}) where  action.parentMetricCode in $0  and (action.tenantId in ['SYSTEM',$1] or action.tenantId is null) return action, labels(action) as actionLabels ")
    List<ActionLabel> getActionAndLabelsByMetricId(List<String> metricIds, String tenantId, String tenantVersion);

}
