/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.kmservice.neo4j;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jProperties;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.data.neo4j.transaction.Neo4jTransactionManager;
import org.springframework.util.StringUtils;

@Configuration
@Import(value={Neo4jProperties.class})
public class Neo4jConfiguration {
    @Autowired
    Neo4jProperties neo4jProperties;

    @Primary
    @Bean(value={"neo4jDriver"})
    public org.neo4j.driver.v1.Driver neo4jDriver() {
        System.out.println("neo4jDriver... url=" + this.neo4jProperties.getUri() + ",username=" + this.neo4jProperties.getUsername() + ",password=" + this.neo4jProperties.getPassword());
        Config config = Config.build().withConnectionTimeout(10L, TimeUnit.SECONDS).withConnectionLivenessCheckTimeout(2L, TimeUnit.MINUTES).withMaxConnectionLifetime(4L, TimeUnit.MINUTES).withMaxConnectionPoolSize(50).withConnectionAcquisitionTimeout(1L, TimeUnit.MINUTES).toConfig();
        return GraphDatabase.driver((String)this.neo4jProperties.getUri(), (AuthToken)AuthTokens.basic((String)this.neo4jProperties.getUsername(), (String)this.neo4jProperties.getPassword()), (Config)config);
    }

    @Primary
    @Bean(value={"ogmDriver"})
    public Driver ogmDriver() {
        BoltDriver ogmDriver = new BoltDriver(this.neo4jDriver());
        return ogmDriver;
    }

    @Primary
    @Bean
    public SessionFactory sessionFactory(ApplicationContext applicationContext) {
        String[] packages = this.getPackagesToScan(applicationContext);
        return new SessionFactory(this.ogmDriver(), packages);
    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
        List packages = EntityScanPackages.get((BeanFactory)applicationContext).getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has((BeanFactory)applicationContext)) {
            packages = AutoConfigurationPackages.get((BeanFactory)applicationContext);
        }
        return StringUtils.toStringArray((Collection)packages);
    }

    @Primary
    @Bean
    public Neo4jTransactionManager transactionManager(ApplicationContext applicationContext) {
        System.out.println("==========neo4jTransactionManager==========");
        return new Neo4jTransactionManager(this.sessionFactory(applicationContext));
    }
}

