package com.digiwin.athena.kmservice.action.metadata;

import com.digiwin.athena.kmservice.common.Neo4jConstants;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionTypeEnum;
import com.digiwin.athena.kmservice.action.execution.model.ThirdPartyActionDefinitionDTO;

import java.util.Map;

public class ThirdPartyActionMetadataGenerator extends ActionMetadataGeneratorBase {
    @Override
    protected ActionDefinitionDTO CreateInstance(Map<String, Object> actionQueryResult) {
        ThirdPartyActionDefinitionDTO metadataDTO = new ThirdPartyActionDefinitionDTO();
        metadataDTO.setUrl(actionQueryResult.get(Neo4jConstants.PROPERTY_EOC_ACTION_URL).toString());
        metadataDTO.setMethod(actionQueryResult.get(Neo4jConstants.PROPERTY_EOC_ACTION_METHOD).toString());
        metadataDTO.setType(ActionTypeEnum.THIRD_PARTY);
        return metadataDTO;
    }
}