package com.digiwin.athena.kmservice.neo4j;


import com.digiwin.athena.kmservice.neo4j.Cql;
import com.digiwin.athena.kmservice.neo4j.Neo4jManager;
import org.neo4j.driver.v1.Driver;


import java.util.List;
import java.util.Map;

/**
 * @author liyuetao
 * @title: Neo4jMultipleUtil
 * @projectName athena_deployer_service
 * @description: TODO
 * @date 2022/9/1313:17
 */
public class Neo4jMultipleUtil {

    public static void executeCql(String cql, Map<String, Object> param, Driver... driver) {
        for (Driver d : driver) {
            if (d != null) {
                Neo4jManager neo4jManager = new Neo4jManager(d);
                neo4jManager.ExecuteNoQuery(cql, param);
            }
        }
    }

    public static void executeCql(String cql, Driver... driver) {
        for (Driver d : driver) {
            if (d != null) {
                Neo4jManager neo4jManager = new Neo4jManager(d);
                neo4jManager.ExecuteNoQuery(cql);
            }
        }
    }

    public static void executeCqlTrans(List<Cql> cqlList, Driver... driver) {
        for (Driver d : driver) {
            if (d != null) {
                Neo4jManager neo4jManager = new Neo4jManager(d);
                neo4jManager.ExecuteTransactionNoQuery(cqlList);
            }
        }
    }
}
